/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteBuffer;

public class Utilities {
    private Utilities() {
    }

    public static String pad(int n) {
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static String pad(String string, int n) {
        String string2 = string;
        int n2 = n - string.length();
        if (n2 > 0) {
            string2 = string + Utilities.pad(n - string.length());
        } else if (n2 < 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String deleteChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != c) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static void dump(PrintWriter printWriter, int n, String string) {
        printWriter.print(Utilities.pad(n));
        printWriter.println(string);
    }

    public static InputStream getInputStream(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            return new FileInputStream(uRL.getFile());
        }
        return uRL.openStream();
    }

    public static void outString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeShort((short)string.length());
        int n = 0;
        while (n < string.length()) {
            dataOutputStream.writeChar(string.charAt(n));
            ++n;
        }
    }

    public static String getString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static String getString(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getShort();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = byteBuffer.getChar();
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static String getProperty(String string, String string2) {
        String string3;
        try {
            string3 = System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            string3 = string2;
        }
        return string3;
    }

    public static boolean getBoolean(String string) {
        boolean bl;
        try {
            bl = Boolean.getBoolean(string);
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    public static Long getLong(String string, long l) {
        Long l2;
        try {
            l2 = Long.getLong(string, l);
        }
        catch (SecurityException securityException) {
            l2 = new Long(l);
        }
        return l2;
    }

    public static Integer getInteger(String string, int n) {
        Integer n2;
        try {
            n2 = Integer.getInteger(string, n);
        }
        catch (SecurityException securityException) {
            n2 = new Integer(n);
        }
        return n2;
    }
}

