package org.argosdic.dictionary;

import java.util.Properties;

import org.eclipse.jface.util.Assert;

/**
 * Dictionary.java
 * @author Xavier Cho
 * @version $Revision: 1.4 $ $Date: 2003/10/06 15:13:01 $
 */
public class Dictionary {
    private String id;
    private String name;
    private String description;
    private String charset;
    private String sourceLang;
    private String targetLang;
    private String copyright;
    private String analyzer;

    public Dictionary(String id, Properties props) {
        this.id = id;
        this.name = props.getProperty("name"); //$NON-NLS-1$
        this.description = props.getProperty("description"); //$NON-NLS-1$
        this.copyright = props.getProperty("copyright"); //$NON-NLS-1$
        this.analyzer = props.getProperty("analyzer"); //$NON-NLS-1$
        this.sourceLang = props.getProperty("source.lang"); //$NON-NLS-1$
        this.targetLang = props.getProperty("target.lang"); //$NON-NLS-1$
        this.charset = props.getProperty("charset"); //$NON-NLS-1$

        Assert.isNotNull(id);
        Assert.isNotNull(name);
    }

    /**
     * @return
     */
    public String getCopyright() {
        return copyright;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @return
     */
    public String getAnalyzer() {
        return analyzer;
    }

    /**
     * @return
     */
    public String getId() {
        return id;
    }

    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @return
     */
    public String getCharset() {
        return charset;
    }

    /**
     * @return
     */
    public String getSourceLang() {
        return sourceLang;
    }

    /**
     * @return
     */
    public String getTargetLang() {
        return targetLang;
    }
}
