package org.argosdic.preference;

import java.io.File;
import java.io.IOException;

import org.argosdic.util.SpecialFolders;
import org.eclipse.jface.preference.PreferenceStore;

/**
 * ArgosDicPreferenceStore.java
 * @author Xavier Cho
 * @version $Revision: 1.7 $ $Date: 2003/10/12 11:34:44 $
 */
public class ArgosDicPreferenceStore extends PreferenceStore {
    public ArgosDicPreferenceStore() throws IOException {
        String path = SpecialFolders.getPreferenceFilePath();
        setFilename(path);

        setDefault("data.dir", SpecialFolders.getDefaultDataDirectory()); //$NON-NLS-1$
        setDefault("server.host", "localhost"); //$NON-NLS-1$ //$NON-NLS-2$
        setDefault("server.port", 9999); //$NON-NLS-1$
        setDefault("location.x", 100); //$NON-NLS-1$
        setDefault("location.y", 100); //$NON-NLS-1$
        setDefault("size.width", 600); //$NON-NLS-1$
        setDefault("size.height", 500); //$NON-NLS-1$
        setDefault("server.workers", 5); //$NON-NLS-1$
        setDefault("wildcard.query.threshold", 2); //$NON-NLS-1$
        setDefault("word.completion.threshold", 3); //$NON-NLS-1$
		setDefault("history.size", 10); //$NON-NLS-1$

        if((new File(path)).exists()) {
            load();
        }
    }
}
