package org.argosdic.util;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * SpecialFolders.java
 * @author Xavier Cho
 * @version $Revision: 1.5 $ $Date: 2003/10/06 15:13:01 $
 */
public class SpecialFolders {
    static Log log = LogFactory.getLog(SpecialFolders.class);

    private static String applicationHome;
    private static String htmlDirectory;
    private static String defaultDataDirectory;
    private static String preferenceFilePath;

    private static void checkDirectory(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Creating directory " + dir.getAbsolutePath()); //$NON-NLS-1$
            }
            dir.mkdirs();
        }
    }

    public static String getUserHomeDirectory() {
        return System.getProperty("user.home"); //$NON-NLS-1$
    }

    public static String getWorkDirectory() {
        return System.getProperty("user.dir"); //$NON-NLS-1$
    }

    public static String getApplicationHomeDirectory() {
        if (applicationHome == null) {
            synchronized (SpecialFolders.class) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(getUserHomeDirectory());
                buffer.append(File.separator);
                buffer.append(".argosdic"); //$NON-NLS-1$

                applicationHome = buffer.toString();

                if (log.isInfoEnabled()) {
                    log.info("Application home dir - " + applicationHome); //$NON-NLS-1$
                }

                checkDirectory(applicationHome);
            }
        }

        return applicationHome;
    }

    public static String getPreferenceFilePath() {
        if (preferenceFilePath == null) {
            synchronized (SpecialFolders.class) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(getApplicationHomeDirectory());
                buffer.append(File.separator);
                buffer.append("preferences.properties"); //$NON-NLS-1$

                preferenceFilePath = buffer.toString();

                if (log.isInfoEnabled()) {
                    log.info("Preference file path - " + preferenceFilePath); //$NON-NLS-1$
                }
            }
        }

        return preferenceFilePath;
    }

    public static String getDefaultDataDirectory() {
        if (defaultDataDirectory == null) {
            synchronized (SpecialFolders.class) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(getWorkDirectory());
                buffer.append(File.separator);
                buffer.append("data"); //$NON-NLS-1$

                defaultDataDirectory = buffer.toString();

                if (log.isInfoEnabled()) {
                    log.info("Default data dir - " + defaultDataDirectory); //$NON-NLS-1$
                }
            }
        }

        return defaultDataDirectory;
    }

    public static String getHtmlDirectory() {
        if (htmlDirectory == null) {
            synchronized (SpecialFolders.class) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(getWorkDirectory());
                buffer.append(File.separator);
                buffer.append("html"); //$NON-NLS-1$

                htmlDirectory = buffer.toString();

                if (log.isInfoEnabled()) {
                    log.info("HTML dir - " + htmlDirectory); //$NON-NLS-1$
                }
            }
        }

        return htmlDirectory;
    }
}