package net.kldp.beat.map;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;

public class ApplicationMap implements Map<String, Object> {

	private ServletContext servletContext;

	public ApplicationMap(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	public void clear() {
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			servletContext.removeAttribute(key);
		}
	}

	public boolean containsKey(Object key) {
		if (servletContext.getAttribute((String) key) != null)
			return true;
		return false;
	}

	public boolean containsValue(Object value) {
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			if (servletContext.getAttribute(key).equals(value)) {
				return true;
			}
		}
		return false;
	}

	public Set<java.util.Map.Entry<String, Object>> entrySet() {
		Map<String, Object> map = new HashMap<String, Object>();
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			String key = attributeNames.nextElement();
			Object value = servletContext.getAttribute(key);
			map.put(key, value);
		}
		return map.entrySet();
	}

	public Object get(Object key) {
		return servletContext.getAttribute((String) key);
	}

	public boolean isEmpty() {
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		if (attributeNames.hasMoreElements())
			return true;
		return false;
	}

	public Set<String> keySet() {
		Set<String> set = new HashSet<String>();
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			set.add(attributeNames.nextElement());
		}
		return set;
	}

	public Object put(String key, Object value) {
		servletContext.setAttribute(key, value);
		return value;
	}

	public void putAll(Map<? extends String, ? extends Object> m) {
		Set<? extends String> keySet = m.keySet();
		for (String key : keySet) {
			servletContext.setAttribute(key, m.get(key));
		}
	}

	public Object remove(Object key) {
		Object obj = servletContext.getAttribute((String) key);
		servletContext.removeAttribute((String) key);
		return obj;
	}

	public int size() {
		int count = 0;
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			attributeNames.nextElement();
			count++;
		}
		return count;
	}

	public Collection<Object> values() {
		Set<Object> set = new HashSet<Object>();
		Enumeration<String> attributeNames = servletContext.getAttributeNames();
		while (attributeNames.hasMoreElements()) {
			Object attribute = servletContext.getAttribute(attributeNames.nextElement());
			set.add(attribute);
		}
		return set;
	}
}