/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class CookieMap
implements Map<String, Cookie> {
    private HttpServletResponse response;
    private HashMap<String, Cookie> cookies = new HashMap();

    public CookieMap(Cookie[] cookieArray, HttpServletResponse httpServletResponse) {
        for (Cookie cookie : cookieArray) {
            this.cookies.put(cookie.getName(), cookie);
        }
        this.response = httpServletResponse;
    }

    @Override
    public void clear() {
        for (String string : this.keySet()) {
            Cookie cookie = this.cookies.remove(string);
            cookie.setMaxAge(0);
            this.response.addCookie(cookie);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.cookies.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.cookies.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Cookie>> entrySet() {
        return this.cookies.entrySet();
    }

    @Override
    public Cookie get(Object object) {
        return this.cookies.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.cookies.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.cookies.keySet();
    }

    @Override
    public Cookie put(String string, Cookie cookie) {
        this.cookies.put(string, cookie);
        this.response.addCookie(cookie);
        return cookie;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Cookie> map) {
        this.cookies.putAll(map);
        for (Cookie cookie : map.values()) {
            this.response.addCookie(cookie);
        }
    }

    @Override
    public Cookie remove(Object object) {
        Cookie cookie = this.cookies.remove(object);
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
        return cookie;
    }

    @Override
    public int size() {
        return this.cookies.size();
    }

    @Override
    public Collection<Cookie> values() {
        return this.cookies.values();
    }
}

