package net.kldp.beat.action;

import net.kldp.beat.exception.ServletPathParseException;

public class ServletPathParser {

	private String path;
	private String suffix;

	public ServletPathParser(String path, String suffix) {
		this.path = path;
		this.suffix = suffix;
	}
	
	public String getTargetClassName() throws ServletPathParseException {
		String dir = path.substring(0, path.lastIndexOf("/") + 1);
		String file = path.substring(path.lastIndexOf("/") + 1);
		return slashToDot(dir) + toUppercaseFirstCharactor(cutSuffix(file, suffix));
	}
	
	private String cutSuffix(String pageName, String suffix) {
		return pageName.substring(0, pageName.lastIndexOf(suffix)-1);
	}

	private String slashToDot(String servletPath) {
		return servletPath.replaceAll("/", "\\.");
	}

	private String toUppercaseFirstCharactor(String str) {
		return String.valueOf(str.charAt(0)).toUpperCase() + str.substring(1);
	}

	public String getDefaultView(String viewSuffix) {
		return cutSuffix(path, suffix) + "." + viewSuffix;
	}
}