package net.kldp.beat.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class CookieMap implements Map<String, Cookie> {

	private HttpServletResponse response;
	private HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();

	public CookieMap(Cookie[] cookieArr, HttpServletResponse response) {
		for (Cookie cookie : cookieArr)
			cookies.put(cookie.getName(), cookie);
		this.response = response;
	}

	public void clear() {
		for (String key : keySet()) {
			Cookie cookie = cookies.remove(key);
			cookie.setMaxAge(0);
			response.addCookie(cookie);
		}
	}

	public boolean containsKey(Object key) {
		return cookies.containsKey(key);
	}

	public boolean containsValue(Object value) {
		return cookies.containsValue(value);
	}

	public Set<java.util.Map.Entry<String, Cookie>> entrySet() {
		return cookies.entrySet();
	}

	public Cookie get(Object key) {
		return cookies.get(key);
	}

	public boolean isEmpty() {
		return cookies.isEmpty();
	}

	public Set<String> keySet() {
		return cookies.keySet();
	}

	public Cookie put(String key, Cookie value) {
		cookies.put(key, value);
		response.addCookie(value);
		return value;
	}

	public void putAll(Map<? extends String, ? extends Cookie> m) {
		cookies.putAll(m);
		for (Cookie cookie : m.values()) {
			response.addCookie(cookie);
		}
	}

	public Cookie remove(Object key) {
		Cookie cookie = cookies.remove(key);
		cookie.setMaxAge(0);
		response.addCookie(cookie);
		return cookie;
	}

	public int size() {
		return cookies.size();
	}

	public Collection<Cookie> values() {
		return cookies.values();
	}
}