package net.kldp.beat.map;

import java.util.Enumeration;

import javax.servlet.http.HttpSession;

public class SessionMap extends AbstractMap {

	private HttpSession session;

	public SessionMap(HttpSession session) {
		this.session = session;
	}

	@Override
	Object getAttribute(String key) {
		return session.getAttribute(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	Enumeration<String> getAttributeNames() {
		return session.getAttributeNames();
	}

	@Override
	void removeAttribute(String key) {
		session.removeAttribute(key);
	}

	@Override
	void setAttribute(String key, Object value) {
		session.setAttribute(key, value);
	}
}