package net.kldp.beat.mock;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServletContextMock implements ServletContext {

	private Map<String, Object> context;
	private Map<String, String> parameter;

	public ServletContextMock(Map<String, Object> context, Map<String, String> parameter) {
		this.context = context;
		this.parameter = parameter;
	}

	@Override
	public Object getAttribute(String key) {
		return context.get(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Enumeration getAttributeNames() {
		return new Hashtable(context).keys();
	}

	@Override
	public ServletContext getContext(String arg0) {
		return null;
	}

	@Override
	public String getInitParameter(String key) {
		return parameter.get(key);
	}

	@Override
	public Enumeration getInitParameterNames() {
		return new Hashtable(parameter).keys();
	}

	@Override
	public int getMajorVersion() {
		return 0;
	}

	@Override
	public String getMimeType(String arg0) {
		return null;
	}

	@Override
	public int getMinorVersion() {
		return 0;
	}

	@Override
	public RequestDispatcher getNamedDispatcher(String arg0) {
		return null;
	}

	@Override
	public String getRealPath(String path) {
		return new File(path).getAbsolutePath();
	}

	@Override
	public RequestDispatcher getRequestDispatcher(String arg0) {
		return null;
	}

	@Override
	public URL getResource(String name) throws MalformedURLException {
		return getClass().getResource(name);
	}

	@Override
	public InputStream getResourceAsStream(String name) {
		return getClass().getResourceAsStream(name);
	}

	@Override
	public Set getResourcePaths(String arg0) {
		return null;
	}

	@Override
	public String getServerInfo() {
		return "ServletContextMock";
	}

	@Override
	public Servlet getServlet(String arg0) throws ServletException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getServletContextName() {
		return "ServletContextMock";
	}

	@Override
	public Enumeration getServletNames() {
		return null;
	}

	@Override
	public Enumeration getServlets() {
		return null;
	}

	@Override
	public void log(String msg) {
		System.out.println(msg);
	}

	@Override
	public void log(Exception e, String msg) {
		System.out.println(msg);
		e.printStackTrace();
	}

	@Override
	public void log(String msg, Throwable t) {
		System.out.println(msg);
		t.printStackTrace();
	}

	@Override
	public void removeAttribute(String key) {
		context.remove(key);
	}

	@Override
	public void setAttribute(String key, Object value) {
		context.put(key, value);
	}
}