/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.ActionMapper;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.action.PropertyCopy;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

public class ActionService {
    private ActionContext context;

    public ActionService(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.context = new ActionContext(httpServletRequest, httpServletResponse, servletContext);
    }

    public void doService(Object object, ActionMapper actionMapper) throws ServletException {
        InterceptorStack interceptorStack = new InterceptorStack(object);
        this.executeSystemInterceptor(object, interceptorStack.getSystemInterceptors());
        PropertyCopy.mapToBean(this.context.getParameterMap(), object);
        if (this.context.hasValidationError()) {
            this.returnToInput(object, interceptorStack.getResult("input"));
            return;
        }
        this.initInterceptors(interceptorStack.getBeforeInterceptors());
        this.initInterceptors(interceptorStack.getAfterInterceptors());
        if (!this.executeInterceptors(object, interceptorStack.getBeforeInterceptors())) {
            this.executeInterceptors(object, interceptorStack.getAfterInterceptors());
            return;
        }
        this.invokeMethod(object, interceptorStack.getBeforeMethod());
        String string = this.executeAction(object);
        Result result = interceptorStack.hasResults() ? interceptorStack.getResult(string) : actionMapper.getDefaultResult();
        this.invokeMethod(object, interceptorStack.getBeforeResultMethod());
        PropertyCopy.beanToMap(object, this.context.getRequestMap());
        this.dispatchView(result, object);
        this.invokeMethod(object, interceptorStack.getAfterMethod());
        this.executeInterceptors(object, interceptorStack.getAfterInterceptors());
    }

    private void initInterceptors(Map<UserInterceptor, Annotation> map) throws InterceptorException {
        for (UserInterceptor userInterceptor : map.keySet()) {
            AnnotationFinder annotationFinder = new AnnotationFinder(userInterceptor.getClass());
            for (Annotation annotation : annotationFinder.getAnnotations()) {
                InterceptorFactory.intecept((UserInterceptor)userInterceptor, (ActionContext)this.context, (Annotation)annotation);
            }
        }
    }

    private void dispatchView(Result result, Object object) throws ServletException {
        try {
            this.context.getDispatcher().dispatch(result, object);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private void returnToInput(Object object, Result result) throws ServletException {
        if (result == null) {
            throw new ServletException("can not found Result annotation for input.");
        }
        PropertyCopy.beanToMap(object, this.context.getRequestMap());
        try {
            this.context.getDispatcher().dispatch(result, object);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private void invokeMethod(Object object, Method method) throws ServletException {
        if (method != null) {
            try {
                method.invoke(object, new Object[]{null});
            }
            catch (Exception exception) {
                throw new ServletException("Can not execute Method");
            }
        }
    }

    private void executeSystemInterceptor(Object object, Map<SystemInterceptor, Annotation> map) throws InterceptorException {
        InterceptorFactory.intecept((Object)object, map, (ActionContext)this.context);
    }

    private boolean executeInterceptors(Object object, Map<UserInterceptor, Annotation> map) throws ServletException {
        boolean bl = true;
        for (UserInterceptor userInterceptor : map.keySet()) {
            if (userInterceptor.intercept(object, map.get(userInterceptor))) continue;
            bl = false;
        }
        return bl;
    }

    private String executeAction(Object object) throws ServletException {
        try {
            Method method = object.getClass().getMethod("execute", new Class[0]);
            return (String)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }
}

