/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.mock;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionMock
implements HttpSession {
    private Map<String, Object> session;
    private long creationTime;
    private int maxInactiveInterval;
    private long lastAccessedTime;

    public HttpSessionMock(Map<String, Object> map) {
        this.session = map;
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
    }

    public Map<String, Object> getSessionMap() {
        return this.session;
    }

    public Object getAttribute(String string) {
        this.setLastAccessedTime();
        return this.session.get(string);
    }

    private void setLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public Enumeration getAttributeNames() {
        return new Hashtable<String, Object>(this.session).keys();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return String.valueOf(this.creationTime);
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String string) {
        return this.session.get(string);
    }

    public String[] getValueNames() {
        return (String[])this.session.keySet().toArray();
    }

    public void invalidate() {
        this.session.clear();
    }

    public boolean isNew() {
        return true;
    }

    public void putValue(String string, Object object) {
        this.session.put(string, object);
    }

    public void removeAttribute(String string) {
        this.session.remove(string);
    }

    public void removeValue(String string) {
        this.session.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.setLastAccessedTime();
        this.session.put(string, object);
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }
}

