package net.kldp.beat.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.ActionMappingException;

/**
 * 모든 액션의 진입점 서블릿입니다.
 * 모든 요청은 UTF-8로 처리됩니다.
 *
 */
public class ActionServlet extends HttpServlet {

	private static final long serialVersionUID = 7123108057071289245L;

	public void destroy() {
		super.destroy();
	}

	@Override
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException,
			IOException {
		doGet(request, response);
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException,
			IOException {
		request.setCharacterEncoding("utf-8");
		ActionMapper mapper = new ActionMapper(request.getServletPath());
		try {
			Object action = mapper.createAction();
			ActionService service = new ActionService(getServletContext(), request, response);
			service.doService(action, mapper);
		} catch (ActionMappingException e) {
			getServletContext().getRequestDispatcher(mapper.getDefaultView()).forward(request, response);
		}
	}

	public void init() throws ServletException {
		Config.load(getClass());
	}
}