package net.kldp.beat.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

import net.kldp.beat.exception.ConfigException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config {
	private static final String SYSTEM_FILE = "/net/kldp/beat/configuration/beat.xml";
	private static final String USER_FILE = "/beat.xml";
	private static Log logger = LogFactory.getLog(Config.class);
	private static Class<?> cl;
	private static ConfigParser parser;

	public static int bufferSize() {
		return parser.bufferSize;
	}

	public static boolean devMode() {
		return parser.devMode;
	}

	public static int maxSize() {
		return parser.maxSize;
	}

	public static String saveDir() {
		if (parser.saveDir.equals("")) {
			parser.saveDir = getDefaultTempDir();
		}
		return parser.saveDir;
	}

	public static ActionMapping defaultMapping() {
		return parser.defaultMapping;
	}

	public static ActionMapping getMapping(String namespace) {
		for (ActionMapping mapping : parser.mappings) {
			if (mapping.getMappingLocation().equals(namespace))
				return mapping;
		}
		return parser.defaultMapping;
	}

	public static String viewType() {
		return parser.viewType;
	}

	public static String viewSuffix() {
		if (parser.viewType.equals("jsp")) {
			return "jsp";
		} else if (parser.viewType.equals("velocity")) {
			return "vm";
		} else if (parser.viewType.equals("freemaker")) {
			return "fm";
		}
		return "jsp";
	}

	public static void load(Class<?> clazz) throws ConfigException {
		cl = clazz;
		URL url = clazz.getResource(USER_FILE);
		if (url != null) {
			try {
				parser = new ConfigParser(new File(url.getFile()));
			} catch (Exception e) {
				logger.fatal(e);
				throw new ConfigException("can not parsing beat configuration file:" + USER_FILE);
			}
		} else {
			url = clazz.getResource(SYSTEM_FILE);
			File file = new File(url.getFile());
			if (!file.exists())
				throw new ConfigException("can not found beat configuration file:" + SYSTEM_FILE);
			try {
				parser = new ConfigParser(file);
				parser.parse();
			} catch (Exception e) {
				logger.error(e);
			}
		}
	}

	public static Properties loadProperties(String filename) throws IOException {
		Properties properties = new Properties();
		properties.load(cl.getResourceAsStream(filename));
		return properties;
	}

	private static String getDefaultTempDir() {
		File file;
		try {
			file = File.createTempFile(String.valueOf(System.currentTimeMillis()), "test");
			String path = file.getAbsolutePath().replace('\\', '/');
			file.delete();
			return path.substring(0, path.lastIndexOf('/') + 1);
		} catch (IOException e) {
			logger.fatal(e);
		}
		return null;
	}
}