package net.kldp.beat.dispatcher;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.kldp.beat.configuration.Config;

public abstract class ViewDispatcher implements Dispatch {

	protected ServletContext context;
	protected HttpServletRequest request;
	protected HttpServletResponse response;
	protected static final String REDIRECT = "redirect";
	protected static final String FORWARD = "forward";
	protected static final String STREAM = "stream";

	public static ViewDispatcher create(ServletContext context, HttpServletRequest request,
			HttpServletResponse response) throws ServletException {
		ViewDispatcher dispatcher;
		if ("jsp".equals(Config.viewType())) {
			dispatcher = new JspViewDispatcher();
		} else if ("velocity".equals(Config.viewType())) {
			dispatcher = new JspViewDispatcher();
		} else if ("freemaker".equals(Config.viewType())) {
			dispatcher = new JspViewDispatcher();
		} else {
			throw new ServletException("can not found dispatcher. check configuration file");
		}

		dispatcher.context = context;
		dispatcher.request = request;
		dispatcher.response = response;
		return dispatcher;
	}

	@Override
	public void dispatch(String url, String type) throws ServletException, IOException {
		if (type.equals(REDIRECT)) {
			response.sendRedirect(url);
		} else if (type.equals(FORWARD)) {
			RequestDispatcher dispatcher = context.getRequestDispatcher(url);
			dispatcher.forward(request, response);
		} else if (type.equals(STREAM)) {
			System.out.println("abcd" + url);
			sendStream(url, response.getOutputStream());
		} else {
			throw new ServletException("can not dispath Result. unknown type - " + type);
		}
	}

	private void sendStream(String filename, OutputStream os) throws IOException {
		FileInputStream in = new FileInputStream(filename);
		byte[] buf = new byte[2048];
		int read = 0;
		while ((read = in.read(buf)) != -1) {
			os.write(buf, 0, read);
		}
		in.close();
		os.close();
	}

	@Override
	public String getQueryString() {
		return request.getQueryString();
	}

	@Override
	public String getRequestURI() {
		return request.getRequestURI();
	}

	protected String getNamespace() {
		String path = request.getServletPath();
		return path.substring(0, path.indexOf('/', 1));
	}

	protected String interpretString(String result, Map<String, Object> map) {
		for (String key : map.keySet()) {
			Object value = map.get(key);
			if (value != null)
				result = result.replace("${" + key + "}", value.toString());
		}
		return result;
	}

	protected String arrayToParam(String[] params) {
		return arrayToParam(params, "&");
	}

	protected String arrayToParam(String[] params, String sep) {
		StringBuffer buffer = new StringBuffer();
		for (String param : params)
			buffer.append(param + sep);
		if (buffer.length() < 1)
			return "";
		return buffer.substring(0, buffer.length() - 1);
	}

	protected String[] parseHeaders(String[] headers, Map<String, Object> map) {
		String header = interpretString(arrayToParam(headers, "\n"), map);
		return header.split("\n");
	}

	protected void addHeaders(String[] headers, HttpServletResponse response) {
		for (String header : headers) {
			String[] split = header.split(":");
			response.addHeader(split[0], split[1]);
		}
	}

	protected String getViewPath() {
		return Config.getMapping(getNamespace()).getViewLocation();
	}
}