/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private SortedMap contents = new TreeMap();
    private CompositeType compositeType;

    public int hashCode() {
        int n = 0;
        n += this.compositeType.hashCode();
        Iterator iterator = this.contents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            n += entry.getValue() == null ? 0 : entry.getValue().hashCode();
        }
        return n;
    }

    public boolean containsValue(Object object) {
        return this.contents.containsValue(object);
    }

    public boolean equals(Object object) {
        CompositeData compositeData;
        if (object == null) {
            return false;
        }
        try {
            compositeData = (CompositeData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getCompositeType().equals(compositeData.getCompositeType())) {
            return false;
        }
        Iterator iterator = this.contents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            boolean bl = entry.getValue() == null ? compositeData.get((String)entry.getKey()) == null : entry.getValue().equals(compositeData.get((String)entry.getKey()));
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "(compositeType=" + this.compositeType.toString() + ",contents=" + this.contents.toString() + ")";
    }

    public boolean containsKey(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(string);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    public Object get(String string) {
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument key cannot be a null or empty String.");
        }
        if (!this.contents.containsKey(string.trim())) {
            throw new InvalidKeyException("Argument key=\"" + string.trim() + "\" is not an existing item name for this CompositeData instance.");
        }
        return this.contents.get(string.trim());
    }

    public Object[] getAll(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        return objectArray;
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be an empty string.");
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map map) throws OpenDataException {
        this(compositeType, map == null ? null : map.keySet().toArray(new String[map.size()]), map == null ? null : map.values().toArray());
    }

    public CompositeDataSupport(CompositeType compositeType, String[] stringArray, Object[] objectArray) throws OpenDataException {
        int n;
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set set = compositeType.keySet();
        CompositeDataSupport.checkForNullElement(stringArray, "itemNames");
        CompositeDataSupport.checkForEmptyString(stringArray, "itemNames");
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument itemValues[] cannot be null or empty.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Array arguments itemNames[] and itemValues[] should be of same length (got " + stringArray.length + " and " + objectArray.length + ").");
        }
        if (stringArray.length != set.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType (found " + stringArray.length + " elements in itemNames[] and itemValues[]," + " expecting " + set.size() + " elements according to compositeType.");
        }
        if (!Arrays.asList(stringArray).containsAll(set)) {
            throw new OpenDataException("Argument itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
        for (n = 0; n < objectArray.length; ++n) {
            OpenType openType = compositeType.getType(stringArray[n]);
            if (objectArray[n] == null || openType.isValue(objectArray[n])) continue;
            throw new OpenDataException("Argument's element itemValues[" + n + "]=\"" + objectArray[n] + "\" is not a valid value for" + " this item (itemName=" + stringArray[n] + ",itemType=" + openType + ").");
        }
        this.compositeType = compositeType;
        for (n = 0; n < stringArray.length; ++n) {
            this.contents.put(stringArray[n], objectArray[n]);
        }
    }
}

