package net.kldp.beat.action;

import java.lang.annotation.Annotation;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.configuration.ActionMapping;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.ActionMappingException;

/**
 * URL에 따라 액션 클래스와 매핑합니다.
 * 
 * @author Administrator
 * 
 */
public class ActionMapper {

	private ServletPathParser parser;

	public ActionMapper(String servletPath) {
		this.parser = new ServletPathParser(servletPath, "action");
	}

	/**
	 * 액션 클래스의 인스턴스를 생성합니다.
	 * 
	 * @return
	 * @throws ActionMappingException
	 */
	public Object createAction() throws ActionMappingException {
		try {
			String target = parser.getTargetClassName();
			return ActionClassPool.get(target).newInstance();
		} catch (Exception e) {
			throw new ActionMappingException("can not found action class");
		}
	}

	public String getDefaultView() {
		ActionMapping mapping = Config.getMapping(parser.getNamespace());
		System.out.println("abc");
		System.out.println(parser.getNamespace());
		System.out.println(mapping);
		System.out.println("abc");
		return mapping.getViewLocation() + parser.getDefaultView(Config.viewSuffix());
	}

	public String getNamespace() {
		return parser.getNamespace();
	}

	/**
	 * 사용자가 액션 클래스에 "success"를 정의하지 않았을 경우에 사용되는 Result입니다.
	 * 
	 * @return
	 */
	public Result getDefaultResult() {
		// 길이가 0 인 배열
		final String[] NULL_STRING_ARRAY = new String[0];
		return new Result() {
			public String name() {
				return "success";
			}

			public String[] params() {
				return (String[]) NULL_STRING_ARRAY;
			}

			public String type() {
				return "forward";
			}

			public String value() {
				return parser.getDefaultView(Config.viewSuffix());
			}

			public Class<? extends Annotation> annotationType() {
				return Result.class;
			}

			public String contentType() {
				return "text/html";
			}

		};
	}
}