package net.kldp.beat.action;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Java빈을 Map으로 복사 또는 그 반대, 또는 Java빈으로 복사하는 유틸리티 클래스 입니다.
 * Java빈은 일반적인 get/set메서드를 가지고 있는 POJO클래스입니다.
 */
public class PropertyCopy {
	private static Log logger = LogFactory.getLog(PropertyCopy.class);

	/**
	 * Bean 객체를 Map객체로 리턴합니다.
	 * @param bean
	 * @return
	 */
	public static Map<String, Object> beanToMap(Object bean) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.putAll(describe(bean));
		return map;
	}

	/**
	 * Bean 객체를 Map객체로 복사합니다.
	 * @param bean
	 * @param map
	 */
	@SuppressWarnings("unchecked")
	public static void beanToMap(Object bean, Map<String, Object> map) {
		map.putAll(describe(bean));
	}

	/**
	 * Map객체를 Bean객체로 복사합니다.
	 * @param map
	 * @param bean
	 */
	public static void mapToBean(Map<String, Object> map, Object bean) {
		populate(bean, map);
	}

	/**
	 * Bean 객체를 Bean객체로 복사합니다.
	 * @param from
	 * @param to
	 */
	public static void beanToBean(Object from, Object to) {
		populate(to, describe(from));
	}

	private static void populate(Object bean, Map<String, Object> map) {
		try {
			BeanUtils.populate(bean, map);
		} catch (IllegalAccessException e) {
			logger.fatal(e);
		} catch (InvocationTargetException e) {
			logger.fatal(e);
		} catch (NullPointerException e) {
			logger.fatal(e);
		}
	}

	@SuppressWarnings("unchecked")
	private static Map<String, Object> describe(Object bean) {
		try {
			Map<String, Object> map;
			map = PropertyUtils.describe(bean);
			map.remove("class");
			return map;
		} catch (IllegalAccessException e) {
			logger.fatal(e);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			logger.fatal(e);
		} catch (NoSuchMethodException e) {
			logger.fatal(e);
		}
		return new HashMap<String, Object>();
	}
}