package net.kldp.beat.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConfigParser {

	boolean devMode;
	String viewType;
	List<ActionMapping> mappings = new ArrayList<ActionMapping>();
	ActionMapping defaultMapping;
	String saveDir;
	int maxSize;
	int bufferSize;
	private Document document;

	public ConfigParser(File file) throws ParserConfigurationException, SAXException, IOException {
		// DOM 파서 생성
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setIgnoringElementContentWhitespace(true);
		DocumentBuilder builder = factory.newDocumentBuilder();
		// XML 문서 파싱하기
		document = builder.parse(file);
	}
	
	public ConfigParser(String uri) throws ParserConfigurationException, SAXException, IOException {
		// DOM 파서 생성
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setIgnoringElementContentWhitespace(true);
		DocumentBuilder builder = factory.newDocumentBuilder();
		// XML 문서 파싱하기
		document = builder.parse(uri);
	}

	public void parse() {

		// 루트 엘리먼트 참조 얻기
		Element eRoot = document.getDocumentElement();

		// 첫번째 book 엘리먼트 정보 얻기
		Element element = (Element) eRoot.getFirstChild();
		while (element != null) {
			String nodeName = element.getNodeName();
			if (nodeName.equals("dev-mode")) {
				this.devMode = Boolean.parseBoolean(getData(element));
			} else if (nodeName.equals("view-type")) {
				this.viewType = getData(element);
			} else if (nodeName.equals("upload")) {
				parseUpload(element);
			} else if (nodeName.equals("action-mapping")) {
				parseActionMapping(element);
			}
			element = (Element) element.getNextSibling();
		}
	}

	private void parseUpload(Element element) {
		element = (Element) element.getFirstChild();
		while (element != null) {
			String nodeName = element.getNodeName();
			if (nodeName.equals("save-dir")) {
				this.saveDir = getData(element);
			} else if (nodeName.equals("max-size")) {
				this.maxSize = Integer.parseInt(getData(element));
			} else if (nodeName.equals("buffer-size")) {
				this.bufferSize = Integer.parseInt(getData(element));
			}
			element = (Element) element.getNextSibling();
		}
	}

	private void parseActionMapping(Element el) {
		el = (Element) el.getFirstChild();
		while (el != null) {
			ActionMapping mapping = new ActionMapping();
			Element vl = (Element) el.getFirstChild();
			String nodeName = el.getNodeName();
			while (vl != null) {
				String nodeName2 = vl.getNodeName();
				if (nodeName2.equals("view-location")) {
					mapping.setViewLocation(getData(vl));
				} else if (nodeName2.equals("mapping-location")) {
					mapping.setMappingLocation(getData(vl));
				} else if (nodeName2.equals("resources")) {
					Element xl = (Element) vl.getFirstChild();
					while (xl != null) {
						String data = getData(xl);
						if (!data.equals(""))
							mapping.addResource(data);
						xl = (Element) xl.getNextSibling();
					}
				}
				vl = (Element) vl.getNextSibling();
			}
			if (nodeName.equals("default-mapping"))
				defaultMapping = mapping;
			else
				mappings.add(mapping);
			el = (Element) el.getNextSibling();
		}
	}

	private String getData(Element el) {
		Text text = (Text) el.getFirstChild();
		if (text != null)
			return text.getData().trim();
		return "";
	}
}