package net.kldp.beat.web.interceptor;

import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.web.aware.ApplicationMapAware;

/**
 * Application scope의 맵을 주입하는 인터셉터입니다.
 *
 */
final class ApplicationMapInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			ApplicationMapAware aware = (ApplicationMapAware) action;
			aware.setApplication(context.getApplicationMap());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		}
	}
}