/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.interceptor.pool;

import java.lang.annotation.Annotation;
import java.util.List;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.AnnotationFinder;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.interceptor.pool.UserInterceptorClassPool;
import net.kldp.beat.system.interceptor.InterceptorFactory;

public class UserInterceptorContainer {
    private Annotation annotation;
    private List<Annotation> systemAnnotations;
    private Class<? extends UserInterceptor> interceptor;

    public UserInterceptorContainer(Annotation annotation) throws ClassNotFoundException {
        this.annotation = annotation;
        this.interceptor = UserInterceptorClassPool.get(annotation);
        this.systemAnnotations = this.findSystemInterceptors();
    }

    private List<Annotation> findSystemInterceptors() {
        AnnotationFinder annotationFinder = new AnnotationFinder(this.interceptor);
        annotationFinder.find();
        return annotationFinder.getAnnotations();
    }

    public Annotation getAnnotatoin() {
        return this.annotation;
    }

    public UserInterceptor getInterceptor(ActionContext actionContext) throws InterceptorException {
        try {
            UserInterceptor userInterceptor = this.interceptor.newInstance();
            for (Annotation annotation : this.systemAnnotations) {
                InterceptorFactory.intecept(userInterceptor, actionContext, annotation);
            }
            return userInterceptor;
        }
        catch (InstantiationException instantiationException) {
            throw new InterceptorException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InterceptorException(illegalAccessException);
        }
    }

    public boolean equals(Object object) {
        if (this.interceptor == null) {
            return false;
        }
        if (object instanceof UserInterceptorContainer) {
            UserInterceptorContainer userInterceptorContainer = (UserInterceptorContainer)object;
            return this.interceptor.equals(userInterceptorContainer.interceptor);
        }
        return false;
    }

    public int hashCode() {
        return 27;
    }
}

