/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.map.AbstractMap;

public class CookieMap
extends AbstractMap<String, Cookie> {
    private HttpServletResponse response;
    private HashMap<String, Cookie> cookies = new HashMap();

    public CookieMap(Cookie[] cookieArray, HttpServletResponse httpServletResponse) {
        for (Cookie cookie : cookieArray) {
            this.cookies.put(cookie.getName(), cookie);
        }
        this.response = httpServletResponse;
    }

    @Override
    Cookie getAttribute(String string) {
        return this.cookies.get(string);
    }

    @Override
    Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.cookies.keySet());
    }

    @Override
    void removeAttribute(String string) {
        Cookie cookie = this.cookies.remove(string);
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
    }

    @Override
    void setAttribute(String string, Cookie cookie) {
        this.cookies.put(string, cookie);
        this.response.addCookie(cookie);
    }
}

