/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.system.interceptor;

import java.lang.annotation.Annotation;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.configuration.Config;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.SpringApplicationContextAware;
import org.springframework.context.ApplicationContext;

final class SpringApplicationContextInterceptor
implements SystemInterceptor {
    SpringApplicationContextInterceptor() {
    }

    @Override
    public void intercept(Object object, ActionContext actionContext, Annotation annotation) throws InterceptorException {
        try {
            SpringApplicationContextAware springApplicationContextAware = (SpringApplicationContextAware)object;
            ApplicationContext applicationContext = Config.getSpringContext();
            if (applicationContext == null) {
                throw new InterceptorException("can not injection spring application context");
            }
            springApplicationContextAware.setContext(applicationContext);
        }
        catch (ClassCastException classCastException) {
            throw new InterceptorException(classCastException);
        }
    }
}

