package net.kldp.beat.dispatcher;

import net.kldp.beat.annotation.Result;
import net.kldp.beat.exception.fatal.ViewDispatcherException;
import net.kldp.beat.util.PropertyCopy;

class JspViewDispatcher extends ViewDispatcher {

	@Override
	public void dispatch(Result input, Object action)
			throws ViewDispatcherException {
		String type = input.type().toLowerCase();
		if (type.equals(FORWARD)) {
			String url = getViewPath() + input.value();
			System.out.println(url);
			url = interpretString(url, PropertyCopy.beanToMap(action));
			if (input.params() != null && input.params().length > 0) {
				String param = interpretString(arrayToParam(input.params()),
						PropertyCopy.beanToMap(action));
				url += "?" + param;
				System.out.println(url);
			}
			dispatch(url, type);
		} else if (type.equals(REDIRECT)) {
			String url = request.getContextPath() + input.value();
			System.out.println(url);
			url = interpretString(url, PropertyCopy.beanToMap(action));
			if (input.params() != null && input.params().length > 0) {
				String param = interpretString(arrayToParam(input.params()),
						PropertyCopy.beanToMap(action));
				url += "?" + param;
				System.out.println(url);
			}
			dispatch(url, type);
		} else if (type.equals(NOTHING)) {
			// nothing
		} else {
			throw new ViewDispatcherException(
					"can not dispath Result. unknown type - " + type);
		}
	}
}