package net.kldp.beat.system.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import net.kldp.beat.annotation.Beat;

/**
 * 요청을 Multipart/Formdata로 파싱합니다.
 * 
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Beat
public @interface MultipartRequest {
	/**
	 * 업로드 허용 사이즈 입니다. kbyte단위
	 * @return
	 */
	int size() default -1;

	/**
	 * 사이즈가 초과되었을 경우에 에러 메세지 키 입니다.
	 * @return
	 */
	String errorKey() default "";

	/**
	 * 사이즈가 초과되었을 경우에 에러 메세지 내용 입니다.
	 * @return
	 */
	String errorMessage() default "";
}