package net.kldp.beat.system.interceptor;

import java.io.IOException;
import java.lang.annotation.Annotation;

import net.kldp.beat.action.ActionContext;
import net.kldp.beat.exception.fatal.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.system.aware.ServletOutputStreamAware;

/**
 * HttpServletResponse의 OutputStream객체를 액션에 주입합니다.
 * 
 */
public class ServletOutputStreamInterceptor implements SystemInterceptor {

	@Override
	public void intercept(Object action, ActionContext context, Annotation annotation)
			throws InterceptorException {
		try {
			ServletOutputStreamAware aware = (ServletOutputStreamAware) action;
			aware.setOutputStream(context.getServletResponse().getOutputStream());
		} catch (ClassCastException e) {
			throw new InterceptorException(e);
		} catch (IOException e) {
			throw new InterceptorException(e);
		}
	}
}
