package net.kldp.beat.upload;

import java.io.File;

public class FormFileImpl extends File implements FormFile {
	private static final long serialVersionUID = 2619755555221510054L;
	private File file;
	private String fieldName;
	private String contentType;

	public FormFileImpl(File file) {
		super(file.getAbsolutePath());
		this.file = file;
	}

	@Override
	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	@Override
	public String getContentType() {
		return contentType;
	}

	@Override
	public String getFileName() {
		return file == null ? null : file.getName();
	}

	@Override
	public int getFileSize() {
		return (int) (file == null ? 0 : file.length());
	}

	@Override
	public String getFileSuffix() {
		String fileName = getFileName();
		if (fileName == null)
			return null;
		String value = fileName.substring(fileName.lastIndexOf('.') + 1, fileName.length());
		if (fileName.lastIndexOf('.') > 0)
			return value;
		else
			return "";
	}
}