# -*- coding: utf-8 -*-
# beemain_gui.py

import sys

try:
    from PyQt4 import QtCore, QtGui
except ImportError:
    printerror(u"Can't import QtCore or QtGui")
    sys.exit(1)

try:
    import Ui_beeencoder,  utils
except ImportError:
    printerror(u"Can't import Ui_beeencoder or util!!")
    sys.exit(1)

try:
    import ModCodec
except ImportError:
    printerror(u"Can't import ModCodec!!")
    sys.exit(1)

# constants
TYPE_URL = 0
TYPE_HEX = 1
TYPE_BASE64 = 2
DIRECT_ENC = 0
DIRECT_DEC = 1

class EncoderDlg(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)
        self.mEnctype = TYPE_URL        # default: 0 is url encoding
        self.mDirection = DIRECT_ENC       # default: 0 is encode
        
        self.ui = Ui_beeencoder.Ui_BeeMainDialog()
        self.ui.setupUi(self)
        
        QtCore.QObject.connect(self.ui.pushButton_close,QtCore.SIGNAL("clicked()"),self.close)
        QtCore.QObject.connect(self.ui.pushButton_conv,QtCore.SIGNAL("clicked()"),self.OnConvert)
        QtCore.QObject.connect(self.ui.radioButton_url,QtCore.SIGNAL("toggled(bool)"),self.OnURLRadioButtionToggled)
        QtCore.QObject.connect(self.ui.radioButton_hex,QtCore.SIGNAL("toggled(bool)"),self.OnHEXRadioButtionToggled)
        QtCore.QObject.connect(self.ui.radioButton_base64,QtCore.SIGNAL("toggled(bool)"),self.OnBASE64RadioButtionToggled)
        QtCore.QObject.connect(self.ui.radioButton_enc,QtCore.SIGNAL("toggled(bool)"),self.OnEncRadioButtionToggled)
        QtCore.QObject.connect(self.ui.radioButton_dec,QtCore.SIGNAL("toggled(bool)"),self.OnDecRadioButtionToggled)
        
    def OnConvert(self):
        try:        # 변환과정에서 발생할 수 있는 예외들을 처리해야 한다. Exception raised during conversion must be handled.
            if self.mDirection == DIRECT_ENC:  # encoding process
                codec = ModCodec.ModCodec(True, self.mEnctype)
                decstr = codec.Operation(self.ui.textEdit_1.toPlainText())
                self.ui.textEdit_2.clear()
                self.ui.textEdit_2.setPlainText(QtCore.QString(decstr))
            elif self.mDirection == DIRECT_DEC:   # decoding process
                codec = ModCodec.ModCodec(False, self.mEnctype)
                encstr = codec.Operation(self.ui.textEdit_2.toPlainText())
                self.ui.textEdit_1.clear()
                if self.mEnctype == TYPE_HEX or self.mEnctype == TYPE_BASE64:
                    temp = QtCore.QString()
                    self.ui.textEdit_1.setPlainText(temp.fromUtf8(encstr))
                else:
                    self.ui.textEdit_1.setPlainText(QtCore.QString(encstr))

            else:
                printerror(u"Unknown Direction!")
                sys.exit(1)
        except (TypeError,  UnicodeError),  e:
            utils.printerror(u"RAISING EXCEPTION!\nMsg: %s\n"% e)
            QtGui.QApplication.closeAllWindows()
            
    def OnURLRadioButtionToggled(self,  e):
        if e:
            self.mEnctype = TYPE_URL
    def OnHEXRadioButtionToggled(self,  e):
        if e:
            self.mEnctype = TYPE_HEX
    def OnBASE64RadioButtionToggled(self,  e):
        if e:
            self.mEnctype = TYPE_BASE64
    def OnEncRadioButtionToggled(self,  e):
        if e:
            self.mDirection = DIRECT_ENC
    def OnDecRadioButtionToggled(self,  e):
        if e:
            self.mDirection = DIRECT_DEC


def main(args):
    app = QtGui.QApplication(args)
    encdlg = EncoderDlg()
    encdlg.show()
    sys.exit(app.exec_())


if __name__ == "__main__":
    main(sys.argv)
    
    

    
