/*
	BRIX: professional edition

- Developed by Minan2DJ07 (Park Byeong-uk, 2nd07@hanmail.net)
- Font Algorithm by Tokigun (http://tokigun.net)
- SDL Library Version Information

  SDL 1.2.9
  SDL_image 1.2.4
  SDL_mixer 1.2.6
- Latest modified: 2006. 5.10
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_image.h>
#include <SDL_endian.h>

/******************************************************************************/
/* constants, variables */
// TitleBar Text
char version[] = "BRIX: professional edition v0.0-dev-20060510";

// is it FULLSCREEN ?
int opt_fullscreen = 0;
// Screen Size, Bitrate
int screen_width = 480;
int screen_height = 272;
int screen_bitrate = 32;

// code by tokigun
#define ARRAYSIZE(x) (sizeof(x)/sizeof(*x))

/******************************************************************************/
/* system dependent functions */
#ifdef WIN32
	#include <windows.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		char b[512];
		sprintf(b,c,s);
		return MessageBox(0,b,version,0);
	}

#else
	#include <dirent.h>

	// Output MessageBox
	int msg(char *c,char *s)
	{
		return fprintf(stderr,c,s);
	}

#endif

/******************************************************************************/
/* general functions */
// function by tokigun
int is_space(int n) { return!(n-9&&n-10&&n-13&&n-32); }

/******************************************************************************/
/* general graphic functions */
// Main Screen Object
SDL_Surface *screen;
// Main Event Object
SDL_Event event;

// functions by tokigun
int putpixel(SDL_Surface *s, int x, int y, int c)
	{ return((Uint32*)s->pixels)[x+y*s->pitch/4]=c; }
int blend(int x, int y, int a, int b)
	{ int i=0;for(;i<24;i+=8)y+=((x>>i&255)-(y>>i&255))*a/b<<i;return y; }

/******************************************************************************/
/* font functions */
// developed by tokigun
char*fontdata="#[RCm#a&#e#;S&e#;C$#;#e&e2Y#e#G#f:i&);V0a;*e%Y#&g7+CC2NP)=aOS=NP"
	"I2+C#fbC(Y;)S#)S/Y3&#hX[S)>OPV=Q<I>^#hh/S#&;#$mseNg#;S#hRe+g#;#&iG;O`YaDDB"
	">R0)jW;C$)a$e&mfh7jSe~a$p?hWir%;#e~C$'jpa/Y;J`YAV0Y;a#hs?S&./#g#b#lB1S$1S$"
	"YBkR&[T#&#kR1[D0I$e#b<C$htb$);C\\*mBebC\\Z;e#iRb0S#)S#)f#krF$f&mRF0Y2lb##h"
	"LkRl2S#hsepS#)/;SC$iReya$g%ibg>fFhra/Y;F$eUeyi2$X88e#A$G2hq+SD0eDb$eHineRf"
	"&F$itA/V;C$e#F0F*hr_<)f?F0I<_$hrb$e@a$fDb$q2C$mbJ0)kbf}b$gehraD$i#a$hr&#g#"
	"eHa#iRIT)AS$*AO<)iRg}f'b$irZ`ZBNP)lre}VPZ>J$k2?;&f>F0I0?#hra$fMa$fhhra#gAN"
	"`I2*/#mBlreBC\\V#&/Y;a#ib;#j#hrgafviBi2YS$%lBNPY=b<F0hr$0Y@aS$*a?Z;$$hr$1O"
	"<_#nrb0S#*[#*[#*;b$hr_#&i#_#hr##';SC$&)+#i0#S&&i#gB+SD0j{r(hrf^qBa/S#b/Y;F"
	"`&htC$);a$e0F0IBkBF0);C0Y;a#hy&#hPkRgBF`*;jB1OT);[*)f#jbgQb/#hdC$);a$gaF0)"
	"hreJgPjR&/#f&&#eQhtC$Y;IT)A[TI<iR?S#j#hb##C@bP)e#jr##CBe~f%jBa#h2gpmBa$);C"
	"$gub#hRb/S#&#jbe=i?gbC\\V#&#jb;CDB;C$)>OT)1#jrhqjBi2YS$%mBNPY=b<&jr$$e??;V"
	";$$nbV[$&;#&;htb@C&?C&?C`*gr1C$e#S$f'1#e~f/n&###h=gGhrSHbJfLu%aT&)";
Uint8 rawfont[16][96], (*zoomfont[16])[96]={rawfont,0,};

int _fontprocess(int x, int y, int z, int c, int s) {
	int i, j;
	for(i=0; i<z; i++)
		for(j=(s==1?z-i:s==3?i+1:0); j<(s==2?i:s==4?z-i-1:z); j++)
			zoomfont[z-1][(y*z+i)*z+j][c] |= 1<<(7-x);
	return z;
}

void fontprocess(int z) {
	int i, j, k, l, t[1596];
	if(z) {
		if(zoomfont[z-1]) return;
		zoomfont[z-1] = malloc(96*16*z*z);
		for(i=0; i<96; i++) {
			for(j=0; j<16*z*z; j++)
				zoomfont[z-1][j][i] = 0;
			for(j=0; j<16; j++)
				for(k=0; k<8; k++) {
					l = (j>0?rawfont[j-1][i]<<k>>6&7:0)<<6 |
						(rawfont[j][i]<<k>>6&7)<<3 |
						(j<15?rawfont[j+1][i]<<k>>6&7:0);
					if((i==3 || i==20) && k<2) l |= (l & 0222) << 1;
					if((i==3 || i==20) && k>6) l |= (l & 0222) >> 1;
					if(l & 0x10) {
						_fontprocess(k, j, z, i, 0);
					} else {
						if((l & 0xda) == 0xa || (l & 0x3f) == 0xb) /* /| */
							_fontprocess(k, j, z, i, 1);
						if((l & 0x1b2) == 0x22 || (l & 0x3f) == 0x26) /* |\ */
							_fontprocess(k, j, z, i, 2);
						if((l & 0x9b) == 0x88 || (l & 0x1f8) == 0xc8) /* \| */
							_fontprocess(k, j, z, i, 3);
						if((l & 0xb6) == 0xa0 || (l & 0x1f8) == 0x1a0) /* |/ */
							_fontprocess(k, j, z, i, 4);
					}
				}
		}
	} else {
		for(i=j=k=0; i<1536; fontdata++) {
			if(*fontdata > 98) {
				for(k=*fontdata++-97; --k; i++) t[i] = t[i-*fontdata+34];
			} else if(*fontdata > 34) {
				j |= (*fontdata - 35) << k*6%8;
				if(k++&3) { t[i++] = j & 0xff; j >>= 8; }
			}
		}
		for(i=0; i<1536; i++) rawfont[i%16][i/16] = t[i];
	}
}

void fontfinalize() {
	int i;
	for(i=1; i<ARRAYSIZE(zoomfont); i++)
		if(zoomfont[i]) free(zoomfont[i]);
}

int printchar(SDL_Surface *s, int x, int y, int z, int c, int u, int v) {
	int i, j;
	if(!is_space(c)) {
		c -= (c<0 ? -96 : c<33 || c>126 ? c : 32);
		for(i=0; i<16*z; i++)
			for(j=0; j<8*z; j++)
				if(zoomfont[z-1][i*z+j%z][c]&(1<<(7-j/z)))
					putpixel(s, x+j, y+i, blend(u, v, i, 16*z-1));
	}
	return 8*z;
}

void printstr(SDL_Surface *s, int x, int y, int z, char *c, int u, int v)
	{ while(*c)x+=printchar(s,x,y,z,(Uint8)*c++,u,v); }
// end devoloped by tokigun

void text(char *c, int x, int y, int u, int v)
{
	printstr(screen, x, y, 1, c, u, v);
}

/******************************************************************************/
/* main routines */
// Initialize Game
void initialize()
{
	//msg("Initialized Game",NULL);
}

// Main Game Processor
void gameproc()
{
	text("game is now executing...", 0, 0, 0xffffff, 0xffffff);
}

// Finalize Game
void finalize()
{
	fontfinalize();
	SDL_FreeSurface(screen);
	SDL_Quit();
	//msg("Finalized Game",NULL);
}

/******************************************************************************/
/* entry point */
// Procedure
BOOL procedure()
{
	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_QUIT: return FALSE;
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym)
				{
					case SDLK_ESCAPE: return FALSE;
				}
				break;
			case SDL_KEYUP: break;
			case SDL_MOUSEMOTION: break;
			case SDL_MOUSEBUTTONDOWN: break;
			case SDL_MOUSEBUTTONUP: break;
		}
	}
	return TRUE;
}

// Entry Point
int main(int argc, char *argv[])
{
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO)<0)
		return msg("SDL Initialization Failure: %s", SDL_GetError());
	atexit(SDL_Quit);
	screen = SDL_SetVideoMode(screen_width, screen_height, screen_bitrate, opt_fullscreen ? SDL_SWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN : SDL_SWSURFACE|SDL_DOUBLEBUF);
    if(!screen) msg("SDL Video Initialization Failure: %s", SDL_GetError());
	SDL_WM_SetCaption(version, 0);
	fontprocess(0);
	fontprocess(2);
	fontprocess(3);
	
	initialize();
	//msg("Game Started",NULL);
	while(1)
	{
		if(!procedure()) break;
		gameproc();
		SDL_Flip(screen);
	}
	finalize();
	return 0;
}