/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.bugzilla.doc;

import com.wgshim.bugzilla.doc.HashMap;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    void transfer(HashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = HashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    void addEntry(int hash, Object key, Object value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, Object value, int bucketIndex) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex]);
        this.table[bucketIndex] = e;
        e.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    private static class Entry
    extends HashMap.Entry {
        Entry before;
        Entry after;

        Entry(int hash, Object key, Object value, HashMap.Entry next) {
            super(hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(HashMap m) {
            LinkedHashMap lm = (LinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        void recordRemoval(HashMap m) {
            this.remove();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        LinkedHashIterator() {
            this.nextEntry = ((LinkedHashMap)LinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            this.nextEntry = e.after;
            return e;
        }

        public abstract Object next();
    }

    private class KeyIterator
    extends LinkedHashIterator {
        KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends LinkedHashIterator {
        EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }
}

