/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.PackageDoc;
import com.wgshim.doclets.HtmlStandardWriter;
import com.wgshim.doclets.Standard;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public abstract class AbstractPackageIndexWriter
extends HtmlStandardWriter {
    protected PackageDoc[] packages;

    public AbstractPackageIndexWriter(String filename) throws IOException {
        super(filename);
        this.packages = Standard.configuration().packages;
    }

    protected abstract void printNavigationBarHeader();

    protected abstract void printNavigationBarFooter();

    protected abstract void printOverviewHeader();

    protected abstract void printIndexHeader(String var1);

    protected abstract void printIndexRow(PackageDoc var1);

    protected abstract void printIndexFooter();

    protected void generatePackageIndexFile() throws IOException {
        this.printHeader(this.getText("doclet.Window_Overview", Standard.configuration().windowtitle));
        this.printNavigationBarHeader();
        this.printOverviewHeader();
        this.generateIndex();
        this.printOverview();
        this.printNavigationBarFooter();
        this.printBodyHtmlEnd();
    }

    protected void printOverview() throws IOException {
    }

    protected void generateIndex() {
        this.printIndexContents(this.packages, "doclet.Package_Summary");
    }

    protected void printIndexContents(PackageDoc[] packages, String text) {
        if (packages.length > 0) {
            Arrays.sort(packages);
            this.printIndexHeader(text);
            this.printAllClassesPackagesLink();
            int i = 0;
            while (i < packages.length) {
                PackageDoc packagedoc = packages[i];
                this.printIndexRow(packagedoc);
                ++i;
            }
            this.printIndexFooter();
        }
    }

    protected void printConfigurationTitle() {
        if (Standard.configuration().doctitle.length() > 0) {
            this.center();
            this.h2();
            ((PrintWriter)((Object)this)).print(Standard.configuration().doctitle);
            this.h2End();
            this.centerEnd();
        }
    }

    protected void navLinkContents() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Overview");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void printAllClassesPackagesLink() {
    }
}

