/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.wgshim.doclets.HtmlStandardWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlStandardWriter {
    protected final ClassTree classtree;

    protected AbstractTreeWriter(String filename, ClassTree classtree) throws IOException, DocletAbortException {
        super(filename);
        this.classtree = classtree;
    }

    protected AbstractTreeWriter(String path, String filename, ClassTree classtree, PackageDoc pkg) throws IOException, DocletAbortException {
        super(path, filename, DirectoryManager.getRelativePath((String)pkg.name()));
        this.classtree = classtree;
    }

    protected void generateLevelInfo(ClassDoc parent, List list) {
        if (list.size() > 0) {
            this.ul();
            int i = 0;
            while (i < list.size()) {
                ClassDoc local = (ClassDoc)list.get(i);
                this.printPartialInfo(local);
                this.printExtendsImplements(parent, local);
                this.generateLevelInfo(local, this.classtree.subs(local));
                ++i;
            }
            this.ulEnd();
        }
    }

    protected void generateTree(List list, String heading) {
        if (list.size() > 0) {
            ClassDoc cd = (ClassDoc)list.get(0);
            this.printTreeHeading(heading);
            this.generateLevelInfo(cd.isClass() ? (ClassDoc)list.get(0) : null, list);
        }
    }

    protected void printExtendsImplements(ClassDoc parent, ClassDoc cd) {
        Object[] interfaces = cd.interfaces();
        if (interfaces.length > (cd.isInterface() ? 1 : 0)) {
            Arrays.sort(interfaces);
            if (cd.isInterface()) {
                ((PrintWriter)((Object)this)).print(" (" + this.getText("doclet.also") + " extends ");
            } else {
                ((PrintWriter)((Object)this)).print(" (implements ");
            }
            boolean printcomma = false;
            int i = 0;
            while (i < interfaces.length) {
                if (parent != interfaces[i]) {
                    if (printcomma) {
                        ((PrintWriter)((Object)this)).print(", ");
                    }
                    this.printPreQualifiedClassLink((ClassDoc)interfaces[i]);
                    printcomma = true;
                }
                ++i;
            }
            ((PrintWriter)((Object)this)).println(")");
        }
    }

    protected void printPartialInfo(ClassDoc cd) {
        boolean isInterface = cd.isInterface();
        this.li("circle");
        ((PrintWriter)((Object)this)).print(isInterface ? "interface " : "class ");
        this.printPreQualifiedBoldClassLink(cd);
    }

    protected void printTreeHeading(String heading) {
        this.h2();
        ((PrintWriter)((Object)this)).println(this.getText(heading));
        this.h2End();
    }

    protected void navLinkTree() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Tree");
        this.fontEnd();
        this.navCellEnd();
    }
}

