/*
 * Decompiled with CFR 0.152.
 */
package com.wgshim.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.Util;
import com.wgshim.doclets.AbstractPackageWriter;
import com.wgshim.doclets.ConfigurationStandard;
import com.wgshim.doclets.Standard;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class PackageFrameWriter
extends AbstractPackageWriter {
    public PackageFrameWriter(String path, String filename, PackageDoc packagedoc) throws IOException, DocletAbortException {
        super(path, filename, packagedoc);
    }

    public static void generate(PackageDoc pkg) throws DocletAbortException {
        String path = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        String filename = "package-frame.html";
        try {
            PackageFrameWriter packgen = new PackageFrameWriter(path, filename, pkg);
            packgen.generatePackageFile();
            ((PrintWriter)((Object)packgen)).close();
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interfaces"));
        this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Classes"));
        this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exceptions"));
        this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Errors"));
    }

    protected void generateClassKindListing(ClassDoc[] arr, String label) {
        if (arr.length > 0) {
            Arrays.sort(arr);
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            ((PrintWriter)((Object)this)).print(label);
            this.fontEnd();
            ((PrintWriter)((Object)this)).println("&nbsp;");
            this.fontStyle("FrameItemFont");
            int i = 0;
            while (i < arr.length) {
                if (Util.isCoreClass((ClassDoc)arr[i]) && this.isGeneratedDoc((Doc)arr[i])) {
                    this.br();
                    this.printTargetClassLink(arr[i], "classFrame");
                }
                ++i;
            }
            this.fontEnd();
            this.printPackageTableFooter();
            ((PrintWriter)((Object)this)).println();
        }
    }

    protected void printPackageHeader(String heading) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packagedoc, "classFrame", heading);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }

    protected void printPackageFooter() {
    }

    protected void printPackageDescription() throws IOException {
    }
}

