/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.Bmp2Jpeg;
import com.conv2.imageGS.IMGFileIO.Bmp2Png;
import com.conv2.imageGS.IMGFileIO.Jpeg2Bmp;
import com.conv2.imageGS.IMGFileIO.Jpeg2Png;
import com.conv2.imageGS.IMGFileIO.Jpeg2Ppm;
import com.conv2.imageGS.IMGFileIO.Png2Bmp;
import com.conv2.imageGS.IMGFileIO.Png2Jpeg;
import java.io.File;

public class ImageConvert {
    private ImageConvert() {
    }

    public static void run(String src_fname, String dest_fname) throws ImageGSException {
        int extName_start = 0;
        File fp = new File(src_fname);
        if (!fp.exists()) {
            throw new ImageGSException("ImageConvert.run() >>  This file is not exist!");
        }
        extName_start = src_fname.lastIndexOf(".");
        String src_ext = src_fname.substring(extName_start + 1).toLowerCase();
        extName_start = dest_fname.lastIndexOf(".");
        String dest_ext = dest_fname.substring(extName_start + 1).toLowerCase();
        if (src_ext.equals("bmp") && (dest_ext.equals("jpg") || dest_ext.equals("jpeg"))) {
            Bmp2Jpeg.run(src_fname, dest_fname);
        } else if (src_ext.equals("bmp") && dest_ext.equals("png")) {
            Bmp2Png.run(src_fname, dest_fname);
        } else if ((src_ext.equals("jpg") || src_ext.equals("jpeg")) && dest_ext.equals("bmp")) {
            Jpeg2Bmp.run(src_fname, dest_fname);
        } else if ((src_ext.equals("jpg") || src_ext.equals("jpeg")) && dest_ext.equals("png")) {
            Jpeg2Png.run(src_fname, dest_fname);
        } else if ((src_ext.equals("jpg") || src_ext.equals("jpeg")) && dest_ext.equals("ppm")) {
            Jpeg2Ppm.run(src_fname, dest_fname);
        } else if (src_ext.equals("png") && dest_ext.equals("bmp")) {
            Png2Bmp.run(src_fname, dest_fname);
        } else if (src_ext.equals("png") && (dest_ext.equals("jpg") || dest_ext.equals("jpeg"))) {
            Png2Jpeg.run(src_fname, dest_fname);
        } else if (src_ext.equals("ppm") && (dest_ext.equals("jpg") || dest_ext.equals("jpeg"))) {
            Png2Jpeg.run(src_fname, dest_fname);
        } else {
            throw new ImageGSException("ImageConvert.run() >> The user's convert method is not support");
        }
    }
}

