/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.JPEGImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JPanel;

public class JPEGImage {
    private String fname;
    private int height;
    private int width;
    private BufferedImage myBufferedImage = null;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private short[][] GrayChannel = null;
    protected JPEGImagePanel panel;
    private int alpha = -16777216;

    public JPEGImage(String fname) throws ImageGSException {
        this.fname = fname;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short[][] getRedChannel() {
        return this.RedChannel;
    }

    public short[][] getGreenChannel() {
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() {
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    private short getR(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getRed(this.myBufferedImage.getRGB(x, y));
    }

    private short getG(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getGreen(this.myBufferedImage.getRGB(x, y));
    }

    private short getB(int x, int y) {
        return (short)this.myBufferedImage.getColorModel().getBlue(this.myBufferedImage.getRGB(x, y));
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }

    private void setPixel(int x, int y, int rgb) {
        this.myBufferedImage.setRGB(x, y, rgb);
    }

    private void setPixel(int x, int y, short r, short g, short b) {
        this.setPixel(x, y, this.packRGB(r, g, b));
    }

    public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(String OutFname, short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutRedChannel, short[][] OutGreenChannel, short[][] OutBlueChannel, int OutHeight, int OutWidth) throws ImageGSException {
        FileOutputStream fstream = null;
        BufferedImage outputBufferedImage = null;
        try {
            try {
                outputBufferedImage = new BufferedImage(OutWidth, OutHeight, 1);
                int i = 0;
                while (i < OutHeight) {
                    int j = 0;
                    while (j < OutWidth) {
                        short r = OutRedChannel[i][j];
                        short g = OutGreenChannel[i][j];
                        short b = OutBlueChannel[i][j];
                        outputBufferedImage.setRGB(j, i, this.packRGB(r, g, b));
                        ++j;
                    }
                    ++i;
                }
                fstream = new FileOutputStream(this.fname);
                JPEGImageEncoder output = JPEGCodec.createJPEGEncoder((OutputStream)fstream);
                JPEGEncodeParam param = output.getDefaultJPEGEncodeParam(outputBufferedImage);
                param.setQuality(1.0f, false);
                output.setJPEGEncodeParam(param);
                output.encode(outputBufferedImage);
                fstream.close();
            }
            catch (Exception e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load() throws ImageGSException {
        FileInputStream fstream = null;
        try {
            try {
                fstream = new FileInputStream(this.fname);
                JPEGImageDecoder input = JPEGCodec.createJPEGDecoder((InputStream)fstream);
                this.myBufferedImage = input.decodeAsBufferedImage();
                this.height = this.myBufferedImage.getHeight();
                this.width = this.myBufferedImage.getWidth();
                this.RedChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
                int i = 0;
                while (i < this.height) {
                    int j = 0;
                    while (j < this.width) {
                        this.RedChannel[i][j] = this.getR(j, i);
                        this.GreenChannel[i][j] = this.getG(j, i);
                        this.BlueChannel[i][j] = this.getB(j, i);
                        this.GrayChannel[i][j] = (short)((double)this.getR(j, i) * 0.299 + (double)this.getG(j, i) * 0.587 + (double)this.getB(j, i) * 0.114);
                        ++j;
                    }
                    ++i;
                }
                fstream.close();
            }
            catch (Exception e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public JPanel getImagePanel() {
        return this.panel;
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        FileInputStream fstream = null;
        try {
            try {
                fstream = new FileInputStream(this.fname);
                JPEGImageDecoder input = JPEGCodec.createJPEGDecoder((InputStream)fstream);
                this.myBufferedImage = input.decodeAsBufferedImage();
                this.panel = new JPEGImagePanel(this.myBufferedImage);
                if (fstream != null) {
                    try {
                        fstream.close();
                        fstream = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
            }
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                    fstream = null;
                }
                catch (IOException iOException) {}
            }
        }
        return this.myBufferedImage;
    }
}

