/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.PPMImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.swing.JPanel;

public class PPMImage {
    public static final int PPM = 1;
    public static int DEFAULT = 1;
    private int type;
    private int alpha = -16777216;
    private String fname;
    private int width;
    private int height;
    protected BufferedImage bimg;
    protected PPMImagePanel panel;
    private short[][] RedChannel = null;
    private short[][] GreenChannel = null;
    private short[][] BlueChannel = null;
    private short[][] GrayChannel = null;

    public PPMImage(int type, String name, int w, int h) throws ImageGSException {
        this.setType(type);
        this.setSize(w, h);
        this.setName(name);
    }

    public PPMImage(int type, String name) throws ImageGSException {
        this(type, name, 0, 0);
    }

    public PPMImage(int type) throws ImageGSException {
        this(type, null, 0, 0);
    }

    public PPMImage(String name) throws ImageGSException {
        this(DEFAULT, name, 0, 0);
    }

    public PPMImage() throws ImageGSException {
        this(DEFAULT, null, 0, 0);
    }

    private int getType() {
        return this.type;
    }

    private void setType(int type) throws ImageGSException {
        if (type != 1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + "No such image type");
        }
        this.type = type;
    }

    public String getName() {
        return new String(this.fname);
    }

    public void setName(String name) {
        this.fname = name != null ? new String(name) : null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public short[][] getRedChannel() {
        return this.RedChannel;
    }

    public short[][] getGreenChannel() {
        return this.GreenChannel;
    }

    public short[][] getBlueChannel() {
        return this.BlueChannel;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    public BufferedImage getBufferedImage() {
        return this.bimg;
    }

    private void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        if (w == 0 || h == 0) {
            this.bimg = null;
            return;
        }
        this.bimg = new BufferedImage(w, h, 1);
        this.panel = new PPMImagePanel(this.bimg);
    }

    public short getR(int x, int y) {
        return (short)this.bimg.getColorModel().getRed(this.bimg.getRGB(x, y));
    }

    public short getG(int x, int y) {
        return (short)this.bimg.getColorModel().getGreen(this.bimg.getRGB(x, y));
    }

    public short getB(int x, int y) {
        return (short)this.bimg.getColorModel().getBlue(this.bimg.getRGB(x, y));
    }

    private int packRGB(short r, short g, short b) {
        return this.alpha + 65536 * r + 256 * g + b;
    }

    private void setPixel(int x, int y, int rgb) {
        this.bimg.setRGB(x, y, rgb);
    }

    private void setPixel(int x, int y, short r, short g, short b) {
        this.setPixel(x, y, this.packRGB(r, g, b));
    }

    private String readHeader(FileInputStream in) throws IOException {
        char ch;
        StringBuffer result = new StringBuffer("");
        while ((ch = (char)in.read()) != '\n') {
            result.append(ch);
        }
        result.append('\n');
        while ((ch = (char)in.read()) == '#') {
            while (in.read() != 10) {
            }
        }
        do {
            result.append(ch);
        } while ((ch = (char)in.read()) != '\n');
        do {
            result.append(ch);
        } while ((ch = (char)in.read()) != '\n');
        result.append('\n');
        return result.toString();
    }

    public JPanel getImagePanel() {
        return this.panel;
    }

    private void setup(String hdr) throws IOException, ImageGSException {
        StreamTokenizer st = new StreamTokenizer(new StringReader(hdr));
        st.eolIsSignificant(false);
        st.commentChar(35);
        st.whitespaceChars(0, 32);
        if (st.nextToken() != -3) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Wrong file format");
        }
        if (!st.sval.equals("P6")) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad magic number");
        }
        int type = 1;
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image width");
        }
        int w = (int)st.nval;
        if (w <= 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image width");
        }
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image height");
        }
        int h = (int)st.nval;
        if (h <= 0) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image height");
        }
        if (st.nextToken() != -2) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad image depth");
        }
        st.eolIsSignificant(true);
        if (st.nextToken() != 10) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">> " + "Bad end of header");
        }
        this.setSize(w, h);
        this.setType(type);
    }

    public void load() throws ImageGSException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.fname);
            String header = this.readHeader(in);
            this.setup(header);
            int total = this.width * this.height;
            short b = -1;
            this.RedChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GreenChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.BlueChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    short r = (short)in.read();
                    short g = (short)in.read();
                    b = (short)in.read();
                    this.setPixel(j, i, r, g, b);
                    this.RedChannel[i][j] = this.getR(j, i);
                    this.GreenChannel[i][j] = this.getG(j, i);
                    this.BlueChannel[i][j] = this.getB(j, i);
                    this.GrayChannel[i][j] = (short)((double)this.RedChannel[i][j] * 0.299 + (double)this.GreenChannel[i][j] * 0.587 + (double)this.BlueChannel[i][j] * 0.114);
                    ++j;
                }
                ++i;
            }
            if (b < 0) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >>" + " Short file");
            }
            in.close();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">>" + e.getMessage());
        }
        catch (ImageGSException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public void load(String fname) throws ImageGSException {
        this.setName(fname);
        this.load();
    }

    private byte short2byte(short n) {
        if (n > 127) {
            return (byte)(n - 256);
        }
        return (byte)n;
    }

    public void save(String fname, short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int height, int width) throws ImageGSException {
        this.fname = fname;
        this.save(Red_ch, Green_ch, Blue_ch, height, width);
    }

    public void save(short[][] Red_ch, short[][] Green_ch, short[][] Blue_ch, int height, int width) throws ImageGSException {
        FileOutputStream out = null;
        PrintWriter pw = null;
        try {
            out = new FileOutputStream(this.fname);
            pw = new PrintWriter(out);
            pw.println("P6");
            pw.print("# CS4735 PPM file I/O API (java).  Atanas Georgiev, 2001 ");
            pw.println("Modification Lee, Moon-Ho, 2002");
            pw.print(width);
            pw.print(" ");
            pw.println(height);
            pw.println("255");
            pw.flush();
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    short r = Red_ch[i][j];
                    short g = Green_ch[i][j];
                    short b = Blue_ch[i][j];
                    out.write(this.short2byte(r));
                    out.write(this.short2byte(g));
                    out.write(this.short2byte(b));
                    ++j;
                }
                ++i;
            }
            pw.close();
            out.close();
        }
        catch (Exception e) {
            try {
                if (pw != null) {
                    pw.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + ">>" + e.getMessage());
        }
    }
}

