/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.Channel2BufferedImage;
import com.conv2.imageGS.IMGFileIO.ImagePanel;
import com.conv2.imageGS.Util.InitIMGBuf;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JPanel;

public class RAWGrayImage {
    private String fname;
    private BufferedImage myBufferedImage = null;
    private short[][] GrayChannel = null;
    private int height = 0;
    private int width = 0;
    protected ImagePanel panel;

    public RAWGrayImage(String fname, int height, int width) throws ImageGSException {
        this.fname = fname;
        this.height = height;
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short[][] getGrayChannel() {
        return this.GrayChannel;
    }

    public void load() throws ImageGSException {
        FileInputStream in = null;
        boolean length = false;
        int i = 0;
        int j = 0;
        try {
            in = new FileInputStream(this.fname);
            this.GrayChannel = InitIMGBuf.ShortIMGBuf(this.height, this.width);
            i = 0;
            while (i < this.height) {
                j = 0;
                while (j < this.width) {
                    this.GrayChannel[i][j] = (short)in.read();
                    ++j;
                }
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    public JPanel getImagePanel() {
        this.panel = new ImagePanel(this.getBufferedImage());
        return this.panel;
    }

    public BufferedImage getBufferedImage() {
        try {
            Channel2BufferedImage cb = new Channel2BufferedImage();
            cb.gray(this.GrayChannel, this.height, this.width);
            this.myBufferedImage = cb.getBufferedImage();
        }
        catch (ImageGSException imageGSException) {
            // empty catch block
        }
        return this.myBufferedImage;
    }

    public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        this.fname = OutFname;
        this.save(OutGrayChannel, OutHeight, OutWidth);
    }

    public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth) throws ImageGSException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fname);
            int i = 0;
            while (i < OutHeight) {
                int j = 0;
                while (j < OutWidth) {
                    out.write((byte)OutGrayChannel[i][j]);
                    ++j;
                }
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }
}

