/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.IMGFileIO;
import com.conv2.imageGS.IMGFileIO.RAWGrayImage;
import com.conv2.imageGS.Util.CreateFileName;
import java.io.File;

public class ToRAWGrayImage {
    private static final String fmt = "raw";
    private String src_fname = null;
    private String dest_fname = null;
    private int height = 0;
    private int width = 0;

    public ToRAWGrayImage(String src_fname) throws ImageGSException {
        File fp = new File(src_fname);
        if (!fp.exists()) {
            throw new ImageGSException("ToRAWGrayImage.run() >>  This file is not exist!");
        }
        this.src_fname = src_fname;
    }

    public String run() throws ImageGSException {
        IMGFileIO img = new IMGFileIO();
        img.readFileName(this.src_fname);
        short[][] grayChannel = img.getGrayChannel();
        this.height = img.getHeight();
        this.width = img.getWidth();
        String suffix = String.valueOf(this.height) + "x" + this.width;
        this.dest_fname = CreateFileName.getSuffix(this.src_fname, suffix, fmt);
        RAWGrayImage raw = new RAWGrayImage(this.src_fname, this.height, this.width);
        raw.save(this.dest_fname, grayChannel, this.height, this.width);
        return this.dest_fname;
    }

    public void run(String src_fname, String dest_fname) throws ImageGSException {
        IMGFileIO img = new IMGFileIO();
        img.readFileName(src_fname);
        short[][] grayChannel = img.getGrayChannel();
        this.height = img.getHeight();
        this.width = img.getWidth();
        RAWGrayImage raw = new RAWGrayImage(src_fname, this.height, this.width);
        raw.save(dest_fname, grayChannel, this.height, this.width);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

