/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.IMGFileIO.IMGFileIO;
import com.conv2.imageGS.Util.GetRandomKey;
import com.conv2.imageGS.Util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public final class URLIMGFileIO {
    private String protocol;
    private String host;
    private int port;
    private String file;
    private String url;
    private static Vector delete_files_vector = null;
    private int height = 0;
    private int width = 0;
    private short[][] redChannel = null;
    private short[][] greenChannel = null;
    private short[][] blueChannel = null;
    private short[][] grayChannel = null;
    private BufferedImage myBufferedImage = null;
    private URL url_instance = null;
    private String[] applyExt = new String[]{"jpg", "gif", "jpeg", "png"};

    public void readURL(String url) throws ImageGSException {
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            int b;
            this.url_instance = new URL(url);
            this.protocol = this.url_instance.getProtocol();
            this.host = this.url_instance.getHost();
            this.port = this.url_instance.getPort();
            this.file = this.url_instance.getFile();
            this.url = url;
            Object obj = this.url_instance.getContent();
            if (!obj.getClass().getName().equals("sun.awt.image.URLImageSource")) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> this is " + obj.getClass().getName());
            }
            if (!StringUtil.matchStr(this.file.toLowerCase(), this.applyExt)) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "This format is not support.");
            }
            Properties p = System.getProperties();
            String parentImagePath = String.valueOf(p.getProperty("user.dir")) + File.separator + GetRandomKey.getNumber(15);
            String saveImagePath = String.valueOf(parentImagePath) + this.url_instance.getPath();
            File fp = new File(saveImagePath);
            if (fp.exists()) {
                fp.delete();
            }
            String tmpParentImagePath = fp.getParent();
            File fp_parent = new File(tmpParentImagePath);
            fp_parent.mkdirs();
            in = new BufferedInputStream(this.url_instance.openStream());
            out = new FileOutputStream(saveImagePath);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            out.flush();
            out.close();
            IMGFileIO img = new IMGFileIO();
            img.readFileName(saveImagePath);
            this.redChannel = img.getRedChannel();
            this.greenChannel = img.getGreenChannel();
            this.blueChannel = img.getBlueChannel();
            this.grayChannel = img.getGrayChannel();
            this.height = img.getHeight();
            this.width = img.getWidth();
            this.myBufferedImage = img.getBufferedImage();
            img = null;
            URLIMGFileIO.remove_directory(new File(parentImagePath));
        }
        catch (MalformedURLException e1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e1.getMessage());
        }
        catch (IOException e2) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e2.getMessage());
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURL() {
        return this.url;
    }

    public short[][] getRedChannel() throws ImageGSException {
        if (this.redChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Red channel is null");
        }
        return this.redChannel;
    }

    public short[][] getGreenChannel() throws ImageGSException {
        if (this.greenChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Green channel is null");
        }
        return this.greenChannel;
    }

    public short[][] getBlueChannel() throws ImageGSException {
        if (this.blueChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The Blue channel is null");
        }
        return this.blueChannel;
    }

    public short[][] getGrayChannel() throws ImageGSException {
        if (this.grayChannel == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Unknown size of GrayIMG or GrayIMG is null");
        }
        return this.grayChannel;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public BufferedImage getBufferedImage() throws ImageGSException {
        if (this.myBufferedImage == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "BufferedImage is null");
        }
        return this.myBufferedImage;
    }

    private static void remove_directory(File dir) throws IOException {
        delete_files_vector = new Vector();
        URLIMGFileIO.remove_all_files_directory(dir);
        File fp = null;
        int i = delete_files_vector.size() - 1;
        while (i >= 0) {
            fp = new File((String)delete_files_vector.get(i));
            fp.delete();
            --i;
        }
        delete_files_vector = null;
        dir.delete();
    }

    private static void remove_all_files_directory(File dir) throws IOException {
        if (dir.isDirectory()) {
            delete_files_vector.add(dir.getPath());
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                URLIMGFileIO.remove_all_files_directory(new File(dir, children[i]));
                ++i;
            }
        } else {
            dir.delete();
        }
    }
}

