/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockFile {
    private static FileChannel channel;
    private static File file;
    private static FileLock lock;

    public LockFile(String lockFile) throws ImageGSException {
        if (lockFile == null) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The user's value is null");
        }
        try {
            file = new File(lockFile);
            channel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (IOException e) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + e.getMessage());
        }
    }

    public boolean lock() {
        boolean flag = true;
        try {
            lock = channel.lock();
        }
        catch (OverlappingFileLockException e1) {
            flag = false;
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }

    public boolean trylock() {
        boolean flag = true;
        try {
            if (channel == null) {
                flag = false;
            } else {
                lock = channel.tryLock();
            }
        }
        catch (OverlappingFileLockException e1) {
            flag = false;
        }
        catch (IOException e2) {
            flag = false;
        }
        return flag;
    }

    public boolean unlock() throws ImageGSException {
        boolean flag = true;
        try {
            if (lock != null) {
                lock.release();
                lock = null;
            }
            if (channel != null) {
                channel.close();
                channel = null;
            }
            if (file == null) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "The user's value is null");
            }
            file.delete();
            file = null;
            channel = null;
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }
}

