/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.Util.Clamping;
import com.conv2.imageGS.Util.CopyIMGBuf;
import com.conv2.imageGS.Util.DimensionTrans;
import com.conv2.imageGS.Util.GetSizeIMG;
import com.conv2.imageGS.Util.InitIMGBuf;
import com.conv2.imageGS.Util.TypeConv2GrayIMG;

public class SepConv2 {
    private SepConv2() {
    }

    public static short[][] Conv2OP(short[][] grayIMG, double[][] mask) throws ImageGSException {
        double[][] resultTmpIMG = (double[][])SepConv2.Conv2OP((Object)grayIMG, (Object)mask);
        short[][] resultIMG = TypeConv2GrayIMG.Double2ShortGrayIMG(resultTmpIMG);
        resultTmpIMG = null;
        return resultIMG;
    }

    public static int[][] Conv2OP(int[][] grayIMG, double[][] mask) throws ImageGSException {
        double[][] resultTmpIMG = (double[][])SepConv2.Conv2OP((Object)grayIMG, (Object)mask);
        int[][] resultIMG = TypeConv2GrayIMG.Double2IntegerGrayIMG(resultTmpIMG);
        resultTmpIMG = null;
        return resultIMG;
    }

    public static double[][] Conv2OP(double[][] grayIMG, double[][] mask) throws ImageGSException {
        double[][] resultIMG = (double[][])SepConv2.Conv2OP((Object)grayIMG, (Object)mask);
        return resultIMG;
    }

    private static Object Conv2OP(Object objGrayIMG, Object objMask) throws ImageGSException {
        double[][] resultIMG = null;
        double[][] grayIMG = null;
        double[][] mask = null;
        int i = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        double var = 0.0;
        if (objGrayIMG instanceof double[][]) {
            grayIMG = CopyIMGBuf.CopyDoubleGrayIMGBuf((double[][])objGrayIMG);
        } else if (objGrayIMG instanceof short[][]) {
            grayIMG = TypeConv2GrayIMG.Short2DoubleGrayIMG((short[][])objGrayIMG);
        }
        if (objMask instanceof double[][]) {
            mask = CopyIMGBuf.CopyDoubleGrayIMGBuf((double[][])objMask);
        } else if (objMask instanceof short[][]) {
            mask = TypeConv2GrayIMG.Short2DoubleGrayIMG((short[][])objMask);
        }
        if (grayIMG == null || mask == null) {
            throw new ImageGSException("SepConv2.Conv2OP() : Unknown size of GrayIMG or Mask");
        }
        int maskHeight = mask.length;
        int maskWidth = mask[maskHeight - 1].length;
        int height = GetSizeIMG.getHeight(grayIMG);
        int width = GetSizeIMG.getWidth(grayIMG);
        resultIMG = InitIMGBuf.DoubleIMGBuf(height, width);
        double[] kernel = DimensionTrans.Double2SingleArray(mask, maskHeight, maskWidth);
        double[] grayIMGBuf = DimensionTrans.Double2SingleArray(grayIMG, height, width);
        int maskHalfHeight = maskHeight / 2;
        int maskHalfWidth = maskWidth / 2;
        double sum = 0.0;
        i = 0;
        while (i < height) {
            j = 0;
            while (j < width) {
                m = -maskHalfHeight;
                while (m <= maskHalfHeight) {
                    int tmpHeightPos = i + m;
                    int tmpHeightOffset = tmpHeightPos >= 0 && tmpHeightPos < height ? tmpHeightPos * width : i * width;
                    int tmpWidthOffset = maskWidth * (m + maskHalfHeight) + maskHalfWidth;
                    n = -maskHalfWidth;
                    while (n <= maskHalfWidth) {
                        double tmpMaskValue = kernel[tmpWidthOffset + n];
                        if (tmpMaskValue != 0.0) {
                            int tmpWidthPos = j + n;
                            if (tmpWidthPos < 0 || tmpWidthPos >= width) {
                                tmpWidthPos = j;
                            }
                            sum += tmpMaskValue * grayIMGBuf[tmpHeightOffset + tmpWidthPos];
                        }
                        ++n;
                    }
                    ++m;
                }
                resultIMG[i][j] = Clamping.ShortSaturation(sum);
                sum = 0.0;
                ++j;
            }
            ++i;
        }
        kernel = null;
        grayIMGBuf = null;
        return resultIMG;
    }
}

