/*
 * Decompiled with CFR 0.152.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.Exception.ImageGSException;
import com.conv2.imageGS.HistogramProc.Histogram;
import com.conv2.imageGS.HistogramProc.HistogramInfo;
import com.conv2.imageGS.IMGFileIO.IMGFileIO;
import com.conv2.imageGS.Util.GrayIMGInfo;

public class StatisticsIMG {
    private double[] Mean = new double[4];
    private double[] StandardDev = new double[4];
    private double[] Sum = new double[4];
    private double[] Variance = new double[4];
    private HistogramInfo[] hinfo = new HistogramInfo[4];
    private GrayIMGInfo[] ginfo = new GrayIMGInfo[4];
    private String[] NameList = new String[4];
    private Histogram hist = null;

    public StatisticsIMG() {
        this.NameList[0] = "REDCHANNEL";
        this.NameList[1] = "GREENCHANNEL";
        this.NameList[2] = "BLUECHANNEL";
        this.NameList[3] = "GRAYLEVEL";
    }

    public void StatisticsIMGOP(String IMGFileName) throws ImageGSException {
        try {
            this.StatisticsIMGOP(IMGFileName, 1);
        }
        catch (ImageGSException e) {
            throw new ImageGSException(e.getMessage());
        }
    }

    public void StatisticsIMGOP(String IMGFileName, int Method2) throws ImageGSException {
        short[][] RedChannel = null;
        short[][] GreenChannel = null;
        short[][] BlueChannel = null;
        short[][] GrayChannel = null;
        try {
            int j;
            if (Method2 < 0 || Method2 > 1) {
                throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Missing method");
            }
            IMGFileIO img = new IMGFileIO();
            img.readFileName(IMGFileName);
            int height = img.getHeight();
            int width = img.getWidth();
            RedChannel = img.getRedChannel();
            GreenChannel = img.getGreenChannel();
            BlueChannel = img.getBlueChannel();
            GrayChannel = img.getGrayChannel();
            int i = 0;
            while (i < height) {
                j = 0;
                while (j < width) {
                    this.Sum[0] = this.Sum[0] + (double)RedChannel[i][j];
                    this.Sum[1] = this.Sum[1] + (double)GreenChannel[i][j];
                    this.Sum[2] = this.Sum[2] + (double)BlueChannel[i][j];
                    this.Sum[3] = this.Sum[3] + (double)GrayChannel[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                this.Mean[i] = this.Sum[i] / (double)(height * width);
                ++i;
            }
            i = 0;
            while (i < height) {
                j = 0;
                while (j < width) {
                    this.Variance[0] = this.Variance[0] + Math.pow((double)RedChannel[i][j] - this.Mean[0], 2.0);
                    this.Variance[1] = this.Variance[1] + Math.pow((double)GreenChannel[i][j] - this.Mean[1], 2.0);
                    this.Variance[2] = this.Variance[2] + Math.pow((double)BlueChannel[i][j] - this.Mean[2], 2.0);
                    this.Variance[3] = this.Variance[3] + Math.pow((double)GrayChannel[i][j] - this.Mean[3], 2.0);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                this.StandardDev[i] = Math.sqrt(this.Variance[i] / (double)(height * width));
                if (Method2 == 1) {
                    if (i == 0) {
                        this.hist = new Histogram(RedChannel);
                    } else if (i == 1) {
                        this.hist = new Histogram(GreenChannel);
                    } else if (i == 3) {
                        this.hist = new Histogram(BlueChannel);
                    } else if (i == 4) {
                        this.hist = new Histogram(GrayChannel);
                    }
                    this.hinfo[i] = this.hist.getHistogramInfo();
                }
                this.ginfo[i] = new GrayIMGInfo(this.NameList[i], this.hinfo[i], this.Mean[i], this.StandardDev[i], height, width);
                ++i;
            }
        }
        catch (ImageGSException e) {
            throw new ImageGSException(e.getMessage());
        }
    }

    public GrayIMGInfo[] getAllIMGInfo() {
        return this.ginfo;
    }

    public GrayIMGInfo getIMGInfo(String Name) throws ImageGSException {
        int index = -1;
        String upper_name = Name.toUpperCase();
        int i = 0;
        while (i < this.ginfo.length) {
            if (upper_name.compareTo(this.ginfo[i].getName()) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            throw new ImageGSException(String.valueOf(this.getClass().getName()) + " >> " + "Don't equal this argument");
        }
        return this.ginfo[index];
    }
}

