/**
 * Class Name	: ChannelViewer
 * Description	: ش ä display Ѵ.
 * Date 				: 2002/05/02
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/31 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.BinaryProc.*;
import com.conv2.imageGS.Exception.*;

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

/**
 * Ϸ  ʰ ä , 2 ۸  display Ѵ.<br>
 * 2   ϵ    ִ. <p>
 * 
 * - ϵ, ÷ Ѵ.<br>
 * -   ϵ ߰. (2003/05/02)<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.3
 */
public class ChannelViewer extends JFrame 
{
	private ChannelViewer() {}

	// for short type	
	// 2003. 05. 02,    κ ߰ 
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @exception ImageGSException channel  
	  */
	 public static void run(short[][] channel, boolean binaryFlag) throws ImageGSException 
	 {
		 run(channel, true, null);	
	 }
	
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @return    title		(ĸ)
	  * @exception ImageGSException  channel  
	  */
	 public static void run(short[][] channel, boolean binaryFlag, String title) throws ImageGSException 
	 {
	 	if(binaryFlag) 
	 	{
			run(Binary2GrayIMG.ShortBinary2GrayIMG(channel), title);
	 	}
	 	else 
	 	{
	 		run(channel, title);
	 	}
	 }
	 
   /**
     * ش ϵ ä , 2 ۸  display Ѵ.
     * 
	 * @param	grayChannel	short type 2 
     * @exception ImageGSException grayChannel  
     */
	public static void run(short[][] grayChannel) throws ImageGSException 
	{
		run(grayChannel, null);	
	}
	
   /**
     * ش ϵ ä , 2 ۸  display Ѵ. 
     * 
	 * @param	grayChannel	short type 2 
     * @return    title		(ĸ)
     * @exception ImageGSException  grayChannel  
     */
	public static void run(short[][] grayChannel, String title) throws ImageGSException 
	{
		String title_str = null;
		
		if(title == null) title_str = "ϵ Դϴ."; 
		else title_str = title;
		
		try 
		{
			// 2 ۸ BufferedImage ȯ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.gray(grayChannel);
			BufferedImage bi = cb.getBufferedImage();
			
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(title);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
		}
	}	

   /**
     * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
     * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	short type red channel
	 * @param	greenChannel	short type green channel
	 * @param	blueChannel	short type blue channel
     * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
     */
	public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel) throws ImageGSException 
	{
		run(redChannel, greenChannel, blueChannel, null);	
	}
	
   /**
     * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
     * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	short type red channel
	 * @param	greenChannel	short type green channel
	 * @param	blueChannel	short type blue channel
     * @return    title		(ĸ)
     * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
     */
	public static void run(short[][] redChannel, short[][] greenChannel, short[][] blueChannel, String title) throws ImageGSException 
	{
		String title_str = null;
		
		if(title == null) title_str = "÷ Դϴ."; 
		else title_str = title;
		
		try 
		{
			// 2 ۸ BufferedImage ȯ.
			Channel2BufferedImage cb = new Channel2BufferedImage();
			cb.color(redChannel, greenChannel, blueChannel);
			BufferedImage bi = cb.getBufferedImage();
			
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(title);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
		}
	}	


	// for double type	
	// 2003. 05. 02,    κ ߰ 
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	double type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @exception ImageGSException channel  
	  */
	 public static void run(double[][] channel, boolean binaryFlag) throws ImageGSException 
	 {
		 run(channel, true, null);	
	 }
	
	/**
	  * ش /ϵ ä , 2 ۸  display Ѵ. 
	  * 
	  * @param	channel	short type 2 
	  * @param	binaryFlag	true :  / false : ϵ
	  * @return    title		(ĸ)
	  * @exception ImageGSException  channel  
	  */
	 public static void run(double[][] channel, boolean binaryFlag, String title) throws ImageGSException 
	 {
		if(binaryFlag) 
		{
			run(Binary2GrayIMG.DoubleBinary2GrayIMG(channel), title);
		}
		else 
		{
			run(channel, title);
		}
	 }
	 
   /**
	 * ش ϵ ä , 2 ۸  display Ѵ. 
	 * 
	 * @param	grayChannel	double type 2 
	 * @exception ImageGSException grayChannel  
	 */
	public static void run(double[][] grayChannel) throws ImageGSException 
	{
		run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), null);	
	}
	
   /**
	 * ش ϵ ä , 2 ۸  display Ѵ.
	 * 
	 * @param	grayChannel	double type 2 
	 * @return    title		(ĸ)
	 * @exception ImageGSException  grayChannel  
	 */
	public static void run(double[][] grayChannel, String title) throws ImageGSException 
	{
		run(TypeConv2GrayIMG.Double2ShortGrayIMG(grayChannel), title);	
	}	

   /**
	 * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	 * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	double type red channel
	 * @param	greenChannel	double type green channel
	 * @param	blueChannel	double type blue channel
	 * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	 */
	public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel) throws ImageGSException 
	{
		run(TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), 
			TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), 
			TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), 
			null);	
	}
	
   /**
	 * Red, Green, Blue ä ģ ÷ ۸  display Ѵ.  <p>
	 * 
	 *  ä ϵ  Ѵٸ, <br>
	 * 3 ä   ÷  .<p>
	 * 
	 * @param	redChannel	double type red channel
	 * @param	greenChannel	double type green channel
	 * @param	blueChannel	double type blue channel
	 * @return    title		(ĸ)
	 * @exception ImageGSException	 channel ũⰡ ġ  ʰų,    
	 */
	public static void run(double[][] redChannel, double[][] greenChannel, double[][] blueChannel, String title) throws ImageGSException 
	{
		run(TypeConv2GrayIMG.Double2ShortGrayIMG(redChannel), 
			TypeConv2GrayIMG.Double2ShortGrayIMG(greenChannel), 
			TypeConv2GrayIMG.Double2ShortGrayIMG(blueChannel), 
			title);	
	}	
	
   /**
     * ش BufferedImage display Ѵ.
     * 
	 * @param	bi	BufferedImage Ÿ 
     * @exception ImageGSException 
     */	
	public static void run(BufferedImage bi) throws ImageGSException 
	{
		run(bi, null);
	}	
	
   /**
     * ش BufferedImage display Ѵ. 
     * 
	 * @param	bi	BufferedImage Ÿ 
     * @return    title		(ĸ)
     * @exception ImageGSException 
     */	
	public static void run(BufferedImage bi, String title) throws ImageGSException 
	{
		String title_str = null;
		
		if(title == null) title_str = "BufferedImage ݴϴ."; 
		else title_str = title;
		
		try 
		{			
			ImagePanel ip = new ImagePanel(bi);
					
			JFrame fr = new JFrame(title);
			fr.getContentPane().add(ip, BorderLayout.CENTER);
			fr.pack();
			fr.setVisible(true);		
		} 
		catch (Exception e)
		{
			throw new ImageGSException("ChannelViewer.run() >> " + e.getMessage());
		}		
	}

}