/**
 * Class Name	: Gif2Jpeg 
 * Description	: GIF Ÿ ÷  JPEG Ÿ ȯ
 * Date 				: 2003/03/31
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/03/31 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.ErrorMsg.*;
import java.io.*;

/**
 * GIF Ÿ  JPEG  Ÿ  ȯѴ.<p>
 * 
 * , ÷  Ѵ. <p>
 *
 * JDK 1.4 ̻󿡼 <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Gif2Jpeg
{
	private Gif2Jpeg() {}

   /**
     * GIF JPEG ȯѴ. 
     * 
	 * @param	gif_fname	GIF  θ
     * @return    jpeg_fname	ȯ JPEG  θ 
     * @exception ImageGSException
     */	
	public static void run(String gif_fname, String jpeg_fname) throws ImageGSException
	{
		File fp_src = new File(gif_fname);
		
		// gif   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("GIF2Jpeg.run() >> " + gif_fname + " : " 
												 + ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}
	
		IMGFileIO img = new IMGFileIO();
		img.ReadGIF(gif_fname);
		
		JPEGImage js = new JPEGImage(jpeg_fname);
		js.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}
