/**
 * Class Name	: Gif2Ppm 
 * Description	: GIF Ÿ ÷   Ÿ ȯ
 * Date 				: 2003/03/31
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/03/31 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * GIF Ÿ  PPM  Ÿ  ȯѴ.<p>
 * 
 * , ÷  Ѵ. <p>
 *
 * JDK 1.4 ̻󿡼 <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Gif2Ppm
{
	private Gif2Ppm() {}

   /**
     * GIF PPM ȯѴ. 
     * 
	 * @param	gif_fname	GIF  θ
     * @return    ppm_fname	ȯ PPM  θ 
     * @exception ImageGSException
     */	
	public static void run(String gif_fname, String ppm_fname) throws ImageGSException
	{
		File fp_src = new File(gif_fname);
		
		// gif   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("GIF2Ppm.run() >> " + gif_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}
	
		IMGFileIO img = new IMGFileIO();
		img.ReadGIF(gif_fname);
		
		PPMImage js = new PPMImage(ppm_fname);
		js.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}
