/**
 * Class Name	: ImageConvert
 * Description	: ش   ϴ   ȯŲ.
 * Date 				: 2002/12/03
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/03 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * ش   ϴ   ȯѴ.<p>
 * 
 *   ȯ   <p>
 * 
 * 1) bmp to jpg <br>
 * 2) bmp to png <br>
 * 3) jpg to bmp <br>
 * 4) jpg to png <br>
 * 5) jpg to ppm <br>
 * 6) png to bmp <br>
 * 7) png to jpeg <br>
 * 8) ppm to jpeg <p>
 * 
 * ࿡   Ȯڸ  ̶ FileOperation.copy() Ǵ move() ϶. <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class ImageConvert
{
	private ImageConvert() {}

   /**
     * ش   ϴ   ȯѴ. 
     * 
	 * @param	src_fname	ش src  θ
     * @return    fname_fname	ȯ dest  θ 
     * @exception ImageGSException
     */		
	static public void run(String src_fname, String dest_fname) throws ImageGSException
	{
		String src_ext;
		String dest_ext;
		int extName_start = 0;
		
		// src_fname ϴ° ˻.
		File fp = new File(src_fname);
		if(fp.exists() == false)
		{
			throw new ImageGSException("ImageConvert.run() >> " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}
		
		// src_fname dest_fname Ȯ ľѴ.	
		
		extName_start = src_fname.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		src_ext = src_fname.substring(extName_start+1).toLowerCase(); // ҹڷ ȯ.
		
		extName_start = dest_fname.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		dest_ext = dest_fname.substring(extName_start+1).toLowerCase(); // ҹڷ ȯ.
		
		// bmp to jpg
		if( src_ext.equals("bmp")==true && (dest_ext.equals("jpg") == true || dest_ext.equals("jpeg") == true) )
		{
			Bmp2Jpeg.run(src_fname, dest_fname);
		}
		// bmp to png
		else if( src_ext.equals("bmp") == true && dest_ext.equals("png") == true)
		{
			Bmp2Png.run(src_fname, dest_fname);	
		}
		// jpg to bmp
		else if( (src_ext.equals("jpg") == true || src_ext.equals("jpeg") == true)  && dest_ext.equals("bmp") == true )
		{
			Jpeg2Bmp.run(src_fname, dest_fname);	
		}
		// jpg to png
		else if( (src_ext.equals("jpg") == true || src_ext.equals("jpeg") == true)  && dest_ext.equals("png") == true ) 
		{
			Jpeg2Png.run(src_fname, dest_fname);	
		}
		// jpg to ppm
		else if( (src_ext.equals("jpg") == true || src_ext.equals("jpeg") == true)  && dest_ext.equals("ppm") == true ) 
		{
			Jpeg2Ppm.run(src_fname, dest_fname);	
		}
		// png to bmp
		else if( src_ext.equals("png") == true && dest_ext.equals("bmp") == true )
		{
			Png2Bmp.run(src_fname, dest_fname);	
		}
		// png to jpeg
		else if( src_ext.equals("png") == true && (dest_ext.equals("jpg") == true || dest_ext.equals("jpeg") == true) )
		{
			Png2Jpeg.run(src_fname, dest_fname);	
		}
		// ppm to jpeg		
		else if( src_ext.equals("ppm") == true && (dest_ext.equals("jpg") == true || dest_ext.equals("jpeg") == true) )
		{
			Png2Jpeg.run(src_fname, dest_fname);	
		}		
		// ̿   ʴ´ٴ  Ȳ .
		else 
		{
			throw new ImageGSException("ImageConvert.run() >> " 
				+ ErrorMsg.ERRORDONTSUPPORTIMGCONVERT );
		} 
		
	}
}
