/**
 * Class Name	: JPEGImage
 * Description	: JPEG handling class.
 * Date 				: 2002/10/09
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/09 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;
import com.sun.image.codec.jpeg.*;
import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.Util.*;
import javax.swing.*;

/**
 * JPEG handling Ŭ with com.sun.image.codec.jpeg package.<p>
 * 
 * , gray level   ʴ´. ̿    <br>
 *  PPM   ÷  Ÿ Ͽ Ѵ.. <br>
 * ׷Ƿ gray level  Ҷ color Ÿ ٲپ ϰ ִ.<br>
 *  imageGS package  ó ˰  ΰ Ƿ,  <br>
 *   ڵ鸵 е鿡 ñ Ѵ.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public class JPEGImage
{
	private String fname;
	private int height;
	private int width;
	private BufferedImage myBufferedImage = null;
	private short [][] RedChannel = null;
	private short [][] GreenChannel = null;
	private short [][] BlueChannel = null;
	private short [][] GrayChannel = null;
	
	protected JPEGImagePanel panel;
	
	// The transparency level, not used
	private int alpha = (int)0xFF000000;
				
	public JPEGImage(String fname) throws ImageGSException
	{
		this.fname = fname;
	}
	
	public int getHeight()
	{
		return height;	
	}
	
	public int getWidth()
	{
		return width;
	}

	public short[][] getRedChannel()
	{
		return (short[][])RedChannel;
	}

	public short[][] getGreenChannel()
	{
		return (short[][])GreenChannel;
	}

	public short[][] getBlueChannel()
	{
		return (short[][])BlueChannel;
	}

	public short[][] getGrayChannel()
	{
		return (short[][])GrayChannel;
	}
	
	// Get pixel values
	private short getR(int x, int y) {
		return (short)(myBufferedImage.getColorModel().getRed(myBufferedImage.getRGB(x,y)));
	}

	private short getG(int x, int y) {
		return (short)(myBufferedImage.getColorModel().getGreen(myBufferedImage.getRGB(x,y)));
	}

	private short getB(int x, int y) {
		return (short)(myBufferedImage.getColorModel().getBlue(myBufferedImage.getRGB(x,y)));
	}

	// Set pixel values
	private int packRGB(short r, short g, short b) {
		return alpha + 65536*r + 256*g + b;
	}

	private void setPixel(int x, int y, int rgb) {
		myBufferedImage.setRGB(x, y, rgb);
	}

	private void setPixel(int x, int y, short r, short g, short b) {
		setPixel(x, y, packRGB(r,g,b));
	}

	public void save(String OutFname, short[][] OutGrayChannel, int OutHeight, int OutWidth)
							throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutGrayChannel, OutHeight, OutWidth);	
	}
		
	public void save(short[][] OutGrayChannel, int OutHeight, int OutWidth)
								throws ImageGSException
	{
		this.save(OutGrayChannel, OutGrayChannel, OutGrayChannel, OutHeight, OutWidth);	
	}

	public void save(String OutFname, 
									short[][] OutRedChannel, 
									short[][] OutGreenChannel, 
									short[][] OutBlueChannel, 
									int OutHeight, int OutWidth
								)
								throws ImageGSException
	{
		this.fname = OutFname;
		this.save(OutRedChannel, OutGreenChannel, OutBlueChannel, OutHeight, OutWidth);	
	}
	
	public void save(short[][] OutRedChannel, 
									short[][] OutGreenChannel, 
									short[][] OutBlueChannel, 
									int OutHeight, int OutWidth
								)
		throws ImageGSException
	{
		int i, j;
		FileOutputStream fstream = null;
		BufferedImage outputBufferedImage = null;
		short r, g, b;
		
		try 
		{
			outputBufferedImage = new BufferedImage(OutWidth,OutHeight, BufferedImage.TYPE_INT_RGB);
			
			// BufferedImage ٲ۴.
			for(i=0; i<OutHeight; i++)
			{
				for(j=0; j<OutWidth; j++)
				{
					r = OutRedChannel[i][j];
					g = OutGreenChannel[i][j];
					b = OutBlueChannel[i][j];
					outputBufferedImage.setRGB(j,i,packRGB(r,g,b));	
				}	
			}
			
			// 
			fstream = new FileOutputStream(fname);
			JPEGImageEncoder output = JPEGCodec.createJPEGEncoder(fstream);
			
			// begin quality 1.0, 2002/10/09
			JPEGEncodeParam param = output.getDefaultJPEGEncodeParam(outputBufferedImage); 
			param.setQuality(1.0f, false); 
			output.setJPEGEncodeParam(param);
			// end quality 1.0

			output.encode(outputBufferedImage);
			fstream.close();
		}
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			
		finally
		{
			if(fstream != null) try { fstream.close(); } catch(IOException se) {}
		}
		
	}
		
	public void load() throws ImageGSException
	{
		int i;
		int j;
		FileInputStream fstream = null;
		
		try{
	
			fstream = new FileInputStream(fname);
			JPEGImageDecoder input = JPEGCodec.createJPEGDecoder(fstream);
			myBufferedImage = input.decodeAsBufferedImage();

			this.height = myBufferedImage.getHeight();
			this.width = myBufferedImage.getWidth();
	
		
			// 2 ̹ Ѵ.
			//  Ҵ
			RedChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GreenChannel = InitIMGBuf.ShortIMGBuf(height, width);
			BlueChannel = InitIMGBuf.ShortIMGBuf(height, width);
			GrayChannel = InitIMGBuf.ShortIMGBuf(height, width);

			for(i=0; i<height; i++)
			{
				for(j=0; j<width; j++)
				{
		
					RedChannel[i][j] = this.getR(j,i);
					GreenChannel[i][j] = this.getG(j,i);
					BlueChannel[i][j] = this.getB(j,i);
					GrayChannel[i][j] =  (short)((float)this.getR(j,i)*0.299  
															+ (float)this.getG(j,i)*0.587 			
															+ (float)this.getB(j,i)*0.114);
				}
			} 	

			fstream.close();
		}
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			
		finally
		{
			if(fstream != null) try { fstream.close(); } catch(IOException se) {}
		}
	}

	// Get image panel
	public JPanel getImagePanel() {
		return panel;
	}
	
	public BufferedImage getBufferedImage()throws ImageGSException
	{
		FileInputStream fstream = null;
		
		try{
			fstream = new FileInputStream(fname);
			JPEGImageDecoder input = JPEGCodec.createJPEGDecoder(fstream);
			myBufferedImage = input.decodeAsBufferedImage();	
			this.panel = new JPEGImagePanel(myBufferedImage);	
			if(fstream != null) 
			{
				try {
					fstream.close(); 
					fstream = null;
				} catch(IOException se) {} 
			}
		}
		catch(Exception e)
		{
			throw new ImageGSException(this.getClass().getName() + " >> "
																+ e.getMessage() );	
		}			
		finally
		{
			if(fstream != null) try { fstream.close(); fstream = null; } catch(IOException se) {}
		}
		
		return myBufferedImage;
	}
}
