/**
 * Class Name	: Jpeg2Bmp
 * Description	: JPEG Ÿ ÷  BMP Ÿ ȯ
 * Date 				: 2002/10/25
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/10/25 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

import java.io.*;

/**
 * JPEG Ÿ  BMP  Ÿ  ȯѴ.
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Jpeg2Bmp
{
	private Jpeg2Bmp() {}

   /**
     * JPEG  PNG ȯѴ. 
     * 
	 * @param	 jpeg_fname	ȯ JPEG  θ	
     * @return	Bmp_fname	PNG  θ 
     * @exception ImageGSException
     * @exception IOException 
     */
	public static void run(String jpeg_fname, String Bmp_fname) throws ImageGSException
	{
		File fp_src = new File(jpeg_fname);
		
		// ppm   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Jpeg2Bmp.run() >> " + jpeg_fname + " : " 
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

		JPEGImage img = new JPEGImage(jpeg_fname);	
		img.load();
			
		IMGFileIO bmp = new IMGFileIO();

		short [][] R = img.getRedChannel();
		short [][] G = img.getGreenChannel();
		short [][] B = img.getBlueChannel();		
		int height = img.getHeight();
		int width = img.getWidth();
		
		bmp.writeBMP(Bmp_fname,  R, G, B, height, width);
	}
}
