/**
 * Class Name	: Png2Bmp
 * Description	: PNG Ÿ ÷  BMP Ÿ ȯ
 * Date 				: 2002/12/03
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/12/03 first created.
 */
package com.conv2.imageGS.IMGFileIO;

import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.ErrorMsg.*;

import java.io.*;

/**
 * PNG Ÿ  BMP Ÿ  ȯѴ.<p>
 * 
 * , ÷  Ѵ. <p>
 *
 * JDK 1.4 ̻󿡼 <p>
 *  
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class Png2Bmp
{
	private Png2Bmp() {}

   /**
     * PNG BMP ȯѴ. 
     * 
	 * @param	png_fname	PNG  θ
     * @return    bmp_fname	ȯ BMP  θ 
     * @exception ImageGSException
     */	
	public static void run(String png_fname, String bmp_fname) throws ImageGSException
	{
		File fp_src = new File(png_fname);
		
		// png   ʴ´ٸ
		if(!fp_src.exists())
		{
			throw new ImageGSException("Png2bmp.run() >> " + png_fname + " : " 
												 + ErrorMsg.ERRORTHISFILEISNOTEXIST);
		}

		IMGFileIO img = new IMGFileIO();
		img.ReadPNG(png_fname);
		
		BMPImage bs = new BMPImage(bmp_fname);
		bs.save(img.getRedChannel(), img.getGreenChannel(), img.getBlueChannel(), img.getHeight(), img.getWidth());
	}
}
