/**
 * Class Name	: URLIMGFileIO
 * Description	: image file handling class.
 * Date				: 2003/05/08
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/05/08 first created.
 */

package com.conv2.imageGS.IMGFileIO;

import java.io.*;
import java.awt.image.*;
import java.net.*;
import java.util.*;

import com.conv2.imageGS.Util.*;
import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * Ʈ(, ) ִ   оδ.  ,   JPEG, PNG, GIF ̴.<p>
 * 
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class URLIMGFileIO
{	
	private String protocol;
	private String host;
	private int port;
	private String file;
	private String url;

	private static Vector delete_files_vector = null;

	/**
	 * ش ÷  height, getHeight() ̿   ִ.
	 */
	private int height = 0;

	/**
	 * ش ÷  width, getWidth() ̿   ִ.
	 */
	private int width = 0;
		
	/**
	 * ش ÷  Red channel, getRedChannel() ̿   ִ.
	 */
	private short[][] redChannel;
	
	/**
	 * ش ÷  Green channel, getGreenChannel() ̿   ִ.
	 */	
	private short[][] greenChannel;

	/**
	 * ش ÷  Blue channel, getBlueChannel() ̿   ִ.
	 */
	private short[][] blueChannel;
	
	/**
	 * ش ÷  Gray level image buf, getGrayChannel() ̿   ִ.
	 */
	private short[][] grayChannel;
	
	/**
	 * ش ÷  BufferedImage, getBufferedImage() ̿   ִ. 
	 */
	private BufferedImage myBufferedImage;
		
	private URL url_instance = null;
	private String[] applyExt = {"jpg", "gif", "jpeg", "png"};

	/**
	 * 
	 */
	public URLIMGFileIO() 
	{
		this.redChannel = null;
		this.greenChannel = null;
		this.blueChannel = null;
		this.grayChannel = null;	
		this.myBufferedImage = null;
	}

	/**
	 *   ִ ش URL оδ.
	 * 
	 * @param url   URL
	 * @throws ImageGSException url  Ȯڰ jpg, jpeg, png, gif  ʴ  
	 */	
	public void readURL(String url) throws ImageGSException
	{
		BufferedInputStream in = null;
		FileOutputStream out = null;
		
		try
		{
			// Step 1 : URL check
			
			url_instance = new URL(url);
			protocol = url_instance.getProtocol();
			host = url_instance.getHost();
			port = url_instance.getPort();
			file = url_instance.getFile();
			this.url = url;

			// url  sun.awt.image.URLImageSource ƴ    Ȳ .
			// ,   ƴ  html, class, au, zip ..  ɷ..			
			// MIME Content-type ϶.
			Object obj = url_instance.getContent();
			if(!obj.getClass().getName().equals("sun.awt.image.URLImageSource"))
			{
				throw new ImageGSException(this.getClass().getName() + " >> this is " + obj.getClass().getName() );		
			}
			
			// file ش Ȯڸ  ʴ  
			if(!StringUtil.matchStr(file.toLowerCase(), applyExt))	
			{
				throw new ImageGSException(this.getClass().getName() + " >> " + ErrorMsg.ERRORNOTSUPPORTFORMAT);		
			}

			// Step 2 :  غ
			
			//  ϰ ִ н ˾Ƴ.
			Properties p = System.getProperties();
			
			String parentImagePath = p.getProperty("user.dir") + File.separator + GetRandomKey.getNumber(15); 
			
			String saveImagePath = parentImagePath +  url_instance.getPath();
			
			// ࿡ ̹ ϰ ִٸ, Ѵ.
			File fp = new File(saveImagePath);
			if(fp.exists()) 
			{
				fp.delete();				
			}

			// ش 丮 Ѵ.
			String tmpParentImagePath = fp.getParent();
			File fp_parent = new File(tmpParentImagePath);
			fp_parent.mkdirs();

			// Step 3 :   ۷ ű,  
						
			// URL Ÿ byte ´.
			in = new BufferedInputStream(url_instance.openStream());
			out = new FileOutputStream(saveImagePath);		
			int b;
			
			// о byte  Ѵ.
			while((b = in.read())!=-1)
			{
				out.write(b);
			}

			in.close();
			out.flush();
			out.close();
			
			IMGFileIO img = new IMGFileIO();
			img.readFileName(saveImagePath);
			
			redChannel = img.getRedChannel();
			greenChannel = img.getGreenChannel();
			blueChannel = img.getBlueChannel();
			grayChannel = img.getGrayChannel();
			height = img.getHeight();
			width = img.getWidth();
			myBufferedImage = img.getBufferedImage(); 
			
			img = null;
			
			//  ӽ÷  丮 .
			remove_directory(new File(parentImagePath));
		}
		catch(MalformedURLException e1)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + e1.getMessage());
		}
		catch(IOException e2)
		{
			if(in != null) try { in.close(); } catch(IOException se) {}
			if(out != null) try { out.close(); } catch(IOException se) {}
			throw new ImageGSException(this.getClass().getName() + " >> " + e2.getMessage());
			
		}		
	}
	
	/**
	 *  ȯѴ. 
	 * 
	 * @return ȯ ݸ 
	 */
	public String getProtocol()
	{
		return protocol;	
	}
	
	/**
	 * ϸ ȯѴ.
	 * 
	 * @return ȯ 
	 */
	public String getFile()
	{
		return file;
	}

	/**
	 * ȣƮ ȯѴ.
	 * 
	 * @return ȯ ȣƮ
	 */
	public String getHost()
	{
		return host;
	}

	/**
	 * Ʈ ȯѴ.
	 * 
	 * @return ȯ Ʈȣ
	 */
	public int getPort()
	{
		return port;
	}

	/**
	 * URL ȯѴ.
	 * 
	 * @return ȯ URL
	 */
	public String getURL()
	{
		return url;
	}

	/**
	 * Red channel ȯ
	 */
	public short [][] getRedChannel() throws ImageGSException
	{
		if(redChannel == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORREDCHANNELISNULL );	
		}
		
		return redChannel;							
	}

	/**
	 * Green channel ȯ
	 */
	public short [][] getGreenChannel() throws ImageGSException
	{
		if(greenChannel == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORGREENCHANNELISNULL );	
		}
		
		return greenChannel;							
	}

	/**
	 * Blue channel ȯ
	 */
	public short [][] getBlueChannel() throws ImageGSException
	{
		if(blueChannel == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORBLUECHANNELISNULL );	
		}
		
		return blueChannel;							
	}
	
	/**
	 * Gray level image buf ȯ
	 */	
	public short [][] getGrayChannel() throws ImageGSException
	{
		if(grayChannel == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG );	
		}
		
		return grayChannel;							
	}
	
	/**
	 * ش  ̸ ȯ
	 */
	public int getHeight()
	{
		return height;	
	}

	/**
	 * ش  ʺ ȯ
	 */
	public int getWidth()
	{
		return width;	
	}
	
	/**
	 * BuffredImage ȯ
	 */	
	public BufferedImage getBufferedImage()	throws ImageGSException
	{
		if(myBufferedImage == null)
		{
			throw new ImageGSException(this.getClass().getName() + " >> " + 
				ErrorMsg.ERRORBUFFEREDIMAGEISNULL );	
		}
		return myBufferedImage;					
	}


	private static void remove_directory(File dir) throws IOException
	{
		delete_files_vector = new Vector();

		// 丮   
		remove_all_files_directory(dir);

		// 丮  丮 
		File fp = null;

		for(int i=delete_files_vector.size()-1; i>=0; i--)
		{
			fp = new File((String)delete_files_vector.get(i));
			fp.delete();
		}

		delete_files_vector = null;
		dir.delete();
	}

	private static void remove_all_files_directory(File dir) throws IOException
	{
		// 丮
		if (dir.isDirectory()) 
		{
			delete_files_vector.add((String)dir.getPath());

			String[] children = dir.list();
			for (int i=0; i<children.length; i++) 
			{
				remove_all_files_directory(new File(dir, children[i])); //  ȣ
			}
		} 
		// 
		else
		{
			dir.delete();
		}
	}	
}